/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.google.inject.Inject;
import com.linemarkers.Edge;
import com.linemarkers.Line;
import com.linemarkers.LineGroup;
import com.linemarkers.LineMarkerConfig;
import com.linemarkers.LineMarkerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class LineMarkerMinimapOverlay
extends Overlay {
    private static final int TILE_SIZE = 4;
    private final Client client;
    private final LineMarkerConfig config;
    private final LineMarkerPlugin plugin;

    @Inject
    LineMarkerMinimapOverlay(Client client, LineMarkerConfig config, LineMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showMinimap()) {
            this.drawMinimap(graphics);
        }
        return null;
    }

    private void drawMinimap(Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setClip(this.plugin.getMinimapClipArea());
        for (LineGroup group : this.plugin.getMarkers()) {
            if (!group.isVisible()) continue;
            for (Line line : group.getLines()) {
                this.drawLine(graphics, line);
            }
        }
    }

    private void drawLine(Graphics2D graphics, Line line) {
        Point start = this.worldToMinimap(Edge.start(line));
        Point end = this.worldToMinimap(Edge.end(line));
        if (start == null || end == null) {
            return;
        }
        graphics.setColor(line.getColour());
        graphics.drawLine(start.getX(), start.getY(), end.getX(), end.getY());
    }

    private Point worldToMinimap(WorldPoint worldPoint) {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        LocalPoint playerLocalPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerLocation);
        if (playerLocalPoint == null) {
            return null;
        }
        int offsetX = playerLocalPoint.getX() - localLocation.getX();
        int offsetY = playerLocalPoint.getY() - localLocation.getY();
        int x = (worldPoint.getX() - playerLocation.getX()) * 4 + offsetX / 32 - 2;
        int y = (worldPoint.getY() - playerLocation.getY()) * 4 + offsetY / 32 - 2 + 1;
        int angle = this.client.getCameraYawTarget() & 0x7FF;
        int sin = (int)(65536.0 * Math.sin((double)angle * 0.0030679615757712823));
        int cos = (int)(65536.0 * Math.cos((double)angle * 0.0030679615757712823));
        Widget minimapDrawWidget = this.plugin.getMinimapDrawWidget();
        if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
            return null;
        }
        int xx = y * sin + cos * x >> 16;
        int yy = sin * x - y * cos >> 16;
        Point loc = minimapDrawWidget.getCanvasLocation();
        int minimapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
        int minimapY = loc.getY() + yy + minimapDrawWidget.getHeight() / 2;
        return new Point(minimapX, minimapY);
    }
}

