/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.google.inject.Inject;
import com.linemarkers.Edge;
import com.linemarkers.Line;
import com.linemarkers.LineGroup;
import com.linemarkers.LineMarkerConfig;
import com.linemarkers.LineMarkerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

class LineMarkerMapOverlay
extends Overlay {
    private final Client client;
    private final LineMarkerConfig config;
    private final LineMarkerPlugin plugin;
    @Inject
    private WorldMapOverlay worldMapOverlay;

    @Inject
    LineMarkerMapOverlay(Client client, LineMarkerConfig config, LineMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showWorldMap()) {
            this.drawWorldMap(graphics);
        }
        return null;
    }

    private void drawWorldMap(Graphics2D graphics) {
        Widget worldMapView = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (worldMapView == null) {
            return;
        }
        Rectangle bounds = worldMapView.getBounds();
        if (bounds == null) {
            return;
        }
        graphics.setClip(this.getWorldMapClipArea(bounds));
        for (LineGroup group : this.plugin.getMarkers()) {
            if (!group.isVisible()) continue;
            for (Line line : group.getLines()) {
                this.drawLine(graphics, line);
            }
        }
    }

    private void drawLine(Graphics2D graphics, Line line) {
        Point start = this.worldMapOverlay.mapWorldPointToGraphicsPoint(Edge.start(line));
        Point end = this.worldMapOverlay.mapWorldPointToGraphicsPoint(Edge.end(line));
        Point delta = this.worldMapOverlay.mapWorldPointToGraphicsPoint(Edge.start(line).dx(1));
        if (start == null || end == null || delta == null) {
            return;
        }
        int offset = (delta.getX() - start.getX()) / 2;
        int x1 = start.getX() - offset;
        int y1 = start.getY() - offset;
        int x2 = end.getX() - offset;
        int y2 = end.getY() - offset;
        graphics.setColor(line.getColour());
        graphics.drawLine(x1, y1, x2, y2);
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }
}

