/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.linemarkers.Line;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;

class LineGroup {
    long id;
    String name;
    boolean visible;
    boolean collapsed;
    List<Line> lines;

    LineGroup(String name, Line line) {
        this(System.currentTimeMillis(), name, true, false, new ArrayList<Line>(Arrays.asList(line)));
    }

    public static List<LineGroup> instances(Client client, List<LineGroup> groups) {
        ArrayList<LineGroup> markers = new ArrayList<LineGroup>();
        for (LineGroup group : groups) {
            ArrayList<Line> lines = new ArrayList<Line>(group.getLines());
            for (Line line : group.getLines()) {
                lines.addAll(Line.instances(client, line));
            }
            markers.add(new LineGroup(group.id, group.name, group.visible, group.collapsed, lines));
        }
        return markers;
    }

    public static boolean isInvalid(LineGroup group) {
        return group == null || group.id <= 0L || group.name == null || group.lines == null;
    }

    public String toString() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineGroup)) {
            return false;
        }
        LineGroup other = (LineGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isCollapsed() != other.isCollapsed()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Line> this$lines = this.getLines();
        List<Line> other$lines = other.getLines();
        return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LineGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isCollapsed() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Line> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        return result;
    }

    private LineGroup(long id, String name, boolean visible, boolean collapsed, List<Line> lines) {
        this.id = id;
        this.name = name;
        this.visible = visible;
        this.collapsed = collapsed;
        this.lines = lines;
    }
}

