/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.linemarkers.Edge;
import com.linemarkers.LineMarkerConfig;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;

class Line {
    Color colour;
    Edge edge;
    double width;
    WorldPoint location;

    Line(LineMarkerConfig config, WorldPoint location) {
        this(config.defaultColour(), config.defaultEdge(), config.defaultWidth(), location);
    }

    public static List<Line> instances(Client client, Line line) {
        return WorldPoint.toLocalInstance((Client)client, (WorldPoint)line.location).stream().map(wp -> new Line(line.colour, line.edge, line.width, (WorldPoint)wp)).collect(Collectors.toList());
    }

    public Color getColour() {
        return this.colour;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public double getWidth() {
        return this.width;
    }

    public WorldPoint getLocation() {
        return this.location;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public void setEdge(Edge edge) {
        this.edge = edge;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Line)) {
            return false;
        }
        Line other = (Line)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        Color this$colour = this.getColour();
        Color other$colour = other.getColour();
        if (this$colour == null ? other$colour != null : !((Object)this$colour).equals(other$colour)) {
            return false;
        }
        Edge this$edge = this.getEdge();
        Edge other$edge = other.getEdge();
        if (this$edge == null ? other$edge != null : !((Object)((Object)this$edge)).equals((Object)other$edge)) {
            return false;
        }
        WorldPoint this$location = this.getLocation();
        WorldPoint other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Line;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $width = Double.doubleToLongBits(this.getWidth());
        result = result * 59 + (int)($width >>> 32 ^ $width);
        Color $colour = this.getColour();
        result = result * 59 + ($colour == null ? 43 : ((Object)$colour).hashCode());
        Edge $edge = this.getEdge();
        result = result * 59 + ($edge == null ? 43 : ((Object)((Object)$edge)).hashCode());
        WorldPoint $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }

    private Line(Color colour, Edge edge, double width, WorldPoint location) {
        this.colour = colour;
        this.edge = edge;
        this.width = width;
        this.location = location;
    }
}

