/*
 * Decompiled with CFR 0.152.
 */
package com.linemarkers;

import com.linemarkers.Line;
import net.runelite.api.coords.WorldPoint;

public enum Edge {
    WEST(0, 0, 0, 1),
    EAST(1, 0, 0, 1),
    SOUTH(0, 0, 1, 0),
    NORTH(0, 1, 1, 0);

    private final int x;
    private final int y;
    private final int dx;
    private final int dy;
    private static final Edge[] EDGES;

    public Edge next() {
        return EDGES[(this.ordinal() + 1) % EDGES.length];
    }

    public static WorldPoint start(Line line) {
        return line.getLocation().dx(line.getEdge().x).dy(line.getEdge().y);
    }

    public static WorldPoint end(Line line) {
        return Edge.start(line).dx(line.getEdge().dx).dy(line.getEdge().dy);
    }

    public String toString() {
        return this.name().charAt(0) + this.name().substring(1).toLowerCase().replaceAll("_", " ");
    }

    private Edge(int x, int y, int dx, int dy) {
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
    }

    static {
        EDGES = Edge.values();
    }
}

