/*
 * Decompiled with CFR 0.152.
 */
package com.bankxpvalue;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Item;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDataCache {
    private static final Logger log = LoggerFactory.getLogger(ItemDataCache.class);
    private static HashMap<String, Integer> skills = new HashMap();
    private static HashMap<Integer, ItemData> cache = new HashMap();
    private final ItemManager itemManager;
    private final Gson gson;

    @Inject
    public ItemDataCache(ItemManager itemManager, Gson gson) {
        this.itemManager = itemManager;
        this.gson = gson;
        this.mapSkills();
        this.populateCache();
    }

    private void mapSkills() {
        skills.put("construction", 0);
        skills.put("cooking", 1);
        skills.put("crafting", 2);
        skills.put("farming", 3);
        skills.put("firemaking", 4);
        skills.put("fletching", 5);
        skills.put("herblore", 6);
        skills.put("prayer", 7);
        skills.put("smithing", 8);
    }

    private void populateCache() {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/item_xp_data.json"), StandardCharsets.UTF_8);){
            ItemDataContainer data = (ItemDataContainer)this.gson.fromJson((Reader)reader, ItemDataContainer.class);
            for (ItemData item : data.items) {
                cache.put(item.id, item);
            }
        }
        catch (IOException e) {
            log.warn("Failed to read item xp data", (Throwable)e);
        }
    }

    public SkillContents[] getTotals(Item[] items) {
        int i;
        SkillContents[] skillContents = new SkillContents[10];
        for (i = 0; i < skillContents.length; ++i) {
            skillContents[i] = new SkillContents(0.0, new ArrayList<ImageComponent>());
        }
        for (i = 0; i < items.length; ++i) {
            if (!cache.containsKey(items[i].getId())) continue;
            ItemData data = cache.get(items[i].getId());
            skillContents[ItemDataCache.skills.get((Object)data.skill).intValue()].total += data.xp * (double)items[i].getQuantity();
            skillContents[9].total += data.xp * (double)items[i].getQuantity();
            AsyncBufferedImage image = this.itemManager.getImage(items[i].getId(), items[i].getQuantity(), true);
            skillContents[ItemDataCache.skills.get((Object)data.skill).intValue()].images.add(new ImageComponent((BufferedImage)image));
        }
        return skillContents;
    }

    public ItemData getItem(int id) {
        if (cache.containsKey(id)) {
            return cache.get(id);
        }
        return null;
    }

    class ItemDataContainer {
        List<ItemData> items;

        public ItemDataContainer(List<ItemData> items) {
            this.items = items;
        }
    }

    class SkillContents {
        public double total;
        public List<ImageComponent> images;

        public SkillContents(double total, List<ImageComponent> images) {
            this.total = total;
            this.images = images;
        }
    }

    class ItemData {
        public int id;
        public double xp;
        public String skill;

        public ItemData(int id, double xp, String skill) {
            this.id = id;
            this.xp = xp;
            this.skill = skill;
        }
    }
}

