/*
 * Decompiled with CFR 0.152.
 */
package com.bankxpvalue;

import com.bankxpvalue.BankXpValueConfig;
import com.bankxpvalue.BankXpValueOverlay;
import com.bankxpvalue.BankXpValuePlugin;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;

@Singleton
public class BankXpValueTutorialOverlay
extends OverlayPanel {
    private final Client client;
    private final BankXpValueConfig config;
    private final BankXpValuePlugin plugin;
    private final BankXpValueOverlay overlay;
    public boolean nextTip = false;
    private Widget bank;

    @Inject
    private BankXpValueTutorialOverlay(Client client, BankXpValueConfig config, BankXpValuePlugin plugin, BankXpValueOverlay overlay) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.overlay = overlay;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showTutorial()) {
            return null;
        }
        this.bank = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (this.bank == null || this.bank.isHidden()) {
            return null;
        }
        Widget button = this.client.getWidget(WidgetInfo.BANK_SETTINGS_BUTTON);
        if (button == null || button.isSelfHidden() || button.getDynamicChildren()[0].getSpriteId() != 195) {
            return null;
        }
        Rectangle bounds = button.getBounds();
        if (!this.nextTip) {
            graphics.setColor(ColorScheme.BRAND_ORANGE);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            FontMetrics font = graphics.getFontMetrics();
            int width = font.stringWidth("Right click this button");
            graphics.setColor(ColorScheme.DARKER_GRAY_COLOR);
            graphics.fillRect(bounds.x + bounds.width + 2, bounds.y - 15, width + 6, 30);
            graphics.setColor(ColorScheme.BRAND_ORANGE);
            graphics.drawString("Right click this button", bounds.x + bounds.width + 5, bounds.y);
            graphics.drawString("to see your Banked XP", bounds.x + bounds.width + 5, bounds.y + 12);
        } else {
            int x = this.overlay.getPreferredLocation().x + 3;
            int y = this.overlay.getPreferredLocation().y + 181;
            graphics.setColor(ColorScheme.BRAND_ORANGE);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.drawRect(x, y, 200, 21);
            FontMetrics font = graphics.getFontMetrics();
            int width = font.stringWidth("Hover over icons");
            graphics.setColor(ColorScheme.DARKER_GRAY_COLOR);
            graphics.fillRect(x + 205, y - 1, width + 2, 30);
            graphics.setColor(ColorScheme.BRAND_ORANGE);
            graphics.drawString("Hover over icons", x + 205, y + 14);
            graphics.drawString("to see items", x + 205, y + 26);
            Point cursor = this.client.getMouseCanvasPosition();
            if (new Rectangle(x, y, 200, 23).contains(cursor.getX(), cursor.getY())) {
                this.nextTip = false;
                this.plugin.hideTutorial();
            }
        }
        return super.render(graphics);
    }
}

