/*
 * Decompiled with CFR 0.152.
 */
package com.bankxpvalue;

import com.bankxpvalue.BankXpValueConfig;
import com.bankxpvalue.BankXpValueItemOverlay;
import com.bankxpvalue.BankXpValueOverlay;
import com.bankxpvalue.BankXpValueTutorialOverlay;
import com.bankxpvalue.ItemDataCache;
import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Bank XP Value", description="All-in-one banked xp viewer + item xp tooltips", tags={"bank", "xp", "calc", "item", "skill", "overlay", "tooltip"})
public class BankXpValuePlugin
extends Plugin {
    public static final String CONFIG_GROUP = "bankxpvalue";
    @Inject
    private Client client;
    @Inject
    private BankXpValueOverlay overlay;
    @Inject
    private BankXpValueTutorialOverlay tutorialOverlay;
    @Inject
    private BankXpValueItemOverlay itemOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BankXpValueConfig config;
    @Inject
    private ItemDataCache data;
    private Widget bank;
    private ItemContainer bankContainer;
    private ItemContainer seedVaultContainer;
    private boolean pluginToggled = false;

    @Provides
    BankXpValueConfig provideConfig(ConfigManager configManager) {
        return (BankXpValueConfig)configManager.getConfig(BankXpValueConfig.class);
    }

    protected void startUp() throws Exception {
        if (this.config.showTutorial()) {
            this.overlayManager.add((Overlay)this.tutorialOverlay);
        }
        if (this.config.showItemXpTooltips()) {
            this.overlayManager.add((Overlay)this.itemOverlay);
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.tutorialOverlay);
        this.overlayManager.remove((Overlay)this.itemOverlay);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() != MenuAction.CC_OP.getId() || !event.getOption().equals("Show menu") || event.getActionParam1() >> 16 != 12) {
            return;
        }
        if (this.config.showTutorial()) {
            this.client.createMenuEntry(-1).setOption("Disable tutorial").setTarget("").setType(MenuAction.WIDGET_FIFTH_OPTION).setIdentifier(event.getIdentifier()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).onClick(e -> this.hideTutorial()).setDeprioritized(true);
        }
        this.client.createMenuEntry(-1).setOption("Toggle Banked XP").setTarget("").setType(MenuAction.RUNELITE).onClick(this::onClick).setDeprioritized(true);
    }

    public void onClick(MenuEntry entry) {
        this.bank = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        if (this.bank == null) {
            this.overlayManager.remove((Overlay)this.overlay);
            this.pluginToggled = false;
            return;
        }
        if (this.config.showTutorial()) {
            this.tutorialOverlay.nextTip = true;
        }
        boolean bl = this.pluginToggled = !this.pluginToggled;
        if (this.pluginToggled) {
            this.calculate();
            this.overlayManager.add((Overlay)this.overlay);
            if (this.config.resetToCenter()) {
                this.overlay.resetPositionToCenter();
            }
        } else {
            this.overlayManager.remove((Overlay)this.overlay);
            this.hideTutorial();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.SEED_VAULT.getId() && this.config.includeSeedVault()) {
            this.seedVaultContainer = this.client.getItemContainer(InventoryID.SEED_VAULT);
        } else if (this.bank != null && event.getContainerId() == InventoryID.BANK.getId()) {
            this.calculate();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getKey().equals("bankxpvalueplugin")) {
            this.hideTutorial();
            this.hideOverlay();
            this.overlayManager.remove((Overlay)this.itemOverlay);
        }
        if (!configChanged.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        if (this.pluginToggled && configChanged.getKey().equals("resetToCenter") && this.config.resetToCenter()) {
            this.overlay.resetPositionToCenter();
        }
        if (configChanged.getKey().equals("tutorial")) {
            if (this.config.showTutorial()) {
                this.hideOverlay();
                this.config.setTutorial(true);
                this.overlayManager.add((Overlay)this.tutorialOverlay);
            } else {
                this.hideTutorial();
            }
        }
        if (configChanged.getKey().equals("includeSeedVault")) {
            this.calculate();
        }
    }

    private Item[] includeSeedVault(Item[] items) {
        ItemContainer container = this.seedVaultContainer;
        if (container == null || container.size() == 0) {
            return items;
        }
        Item[] moreItems = Arrays.copyOf(items, items.length + container.size());
        int count = 0;
        for (int i = items.length; i < moreItems.length; ++i) {
            moreItems[i] = container.getItem(count);
            ++count;
        }
        return moreItems;
    }

    private void calculate() {
        this.bankContainer = this.client.getItemContainer(InventoryID.BANK);
        if (this.bankContainer != null) {
            Item[] items = this.bankContainer.getItems();
            if (this.config.includeSeedVault()) {
                items = this.includeSeedVault(items);
            }
            this.overlay.setXpTotals(this.data.getTotals(items));
        }
    }

    public void hideOverlay() {
        this.pluginToggled = false;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    public void hideTutorial() {
        this.overlayManager.remove((Overlay)this.tutorialOverlay);
        this.config.setTutorial(false);
        this.tutorialOverlay.nextTip = false;
    }
}

