/*
 * Decompiled with CFR 0.152.
 */
package com.bankxpvalue;

import com.bankxpvalue.BankXpValueConfig;
import com.bankxpvalue.BankXpValuePlugin;
import com.bankxpvalue.ItemDataCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.SkillColor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

@Singleton
public class BankXpValueOverlay
extends OverlayPanel {
    private final Client client;
    private final BankXpValuePlugin plugin;
    private final BankXpValueConfig config;
    private final TooltipManager tooltipManager;
    private final SkillIconManager iconManager;
    private final PanelComponent skillsBar;
    private final OverlayManager overlayManager;
    private Widget bank;
    private static final String[] xpTotals = new String[10];
    private static final ArrayList<PanelComponent> itemPanels = new ArrayList();
    private static final HashMap<String, String> potentialLvlUps = new HashMap();
    private int iterationCounter = 0;

    @Inject
    private BankXpValueOverlay(Client client, TooltipManager tooltipManager, BankXpValueConfig config, BankXpValuePlugin plugin, OverlayManager overlayManager) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.tooltipManager = tooltipManager;
        this.overlayManager = overlayManager;
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.setResizable(false);
        this.setResettable(false);
        this.panelComponent.setBackgroundColor(new Color(51, 51, 51, 245));
        this.iconManager = new SkillIconManager();
        this.skillsBar = new PanelComponent();
        this.createSkillsBar();
    }

    public Dimension render(Graphics2D graphics) {
        if (this.getPreferredLocation() == null) {
            this.setPreferredLocation(this.getBounds().getLocation());
            this.resetPositionToCenter();
        }
        this.bank = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        this.panelComponent.getChildren().clear();
        if (this.bank == null || this.bank.isHidden()) {
            this.plugin.hideOverlay();
            if (this.config.showTutorial()) {
                this.plugin.hideTutorial();
            }
            return null;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Banked Experience").build());
        this.panelComponent.setPreferredSize(new Dimension(this.skillsBar.getBounds().width + 6, 0));
        this.displayTotals();
        if (this.iterationCounter >= 0) {
            ++this.iterationCounter;
            if (this.iterationCounter == 2) {
                int x = (int)((double)this.bank.getBounds().x + this.bank.getBounds().getWidth() / 2.0 - this.getBounds().getWidth() / 2.0);
                int y = (int)((double)this.bank.getBounds().y + this.bank.getBounds().getHeight() / 2.0 - this.getBounds().getHeight() / 2.0);
                this.setPreferredLocation(new java.awt.Point(x, y));
                this.overlayManager.saveOverlay((Overlay)this);
                this.iterationCounter = -1;
            }
        }
        Point cursor = this.client.getMouseCanvasPosition();
        if (null != this.getPreferredLocation()) {
            if (this.getBounds().getHeight() >= 200.0) {
                this.setBounds(graphics, cursor, this.getPreferredLocation().x + 5, this.getPreferredLocation().y + 183);
            } else {
                this.setBounds(graphics, cursor, this.getPreferredLocation().x + 5, this.getPreferredLocation().y + 139);
            }
        }
        return super.render(graphics);
    }

    public void setXpTotals(ItemDataCache.SkillContents[] skillContents) {
        for (int i = 0; i < skillContents.length; ++i) {
            BankXpValueOverlay.xpTotals[i] = (int)skillContents[i].total == 0 ? "None" : String.format("%,d", (int)Math.ceil(skillContents[i].total));
        }
        this.createTooltips(skillContents);
        this.setPotentialLevels(skillContents);
    }

    public void resetPositionToCenter() {
        this.iterationCounter = 0;
    }

    private void displayTotals() {
        this.panelComponent.getChildren().add(LineComponent.builder().left("Construction: ").leftColor(SkillColor.CONSTRUCTION.getColor().brighter().brighter()).right(xpTotals[0]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Cooking: ").leftColor(SkillColor.COOKING.getColor().brighter().brighter()).right(xpTotals[1]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Crafting: ").leftColor(SkillColor.CRAFTING.getColor().brighter().brighter()).right(xpTotals[2]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Farming: ").leftColor(SkillColor.FARMING.getColor().brighter().brighter()).right(xpTotals[3]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Firemaking: ").leftColor(new Color(255, 119, 0)).right(xpTotals[4]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Fletching: ").leftColor(SkillColor.FLETCHING.getColor().brighter().brighter()).right(xpTotals[5]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Herblore: ").leftColor(SkillColor.HERBLORE.getColor().brighter().brighter()).right(xpTotals[6]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Prayer: ").leftColor(SkillColor.PRAYER.getColor().brighter().brighter()).right(xpTotals[7]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Smithing: ").leftColor(SkillColor.SMITHING.getColor().brighter().brighter()).right(xpTotals[8]).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Total: ").right(xpTotals[9]).build());
        this.panelComponent.getChildren().add(this.skillsBar);
    }

    private void createSkillsBar() {
        this.skillsBar.setGap(new java.awt.Point(6, 0));
        this.skillsBar.setBackgroundColor(Color.DARK_GRAY);
        this.skillsBar.setOrientation(ComponentOrientation.HORIZONTAL);
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.CONSTRUCTION, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.COOKING, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.CRAFTING, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.FARMING, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.FIREMAKING, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.FLETCHING, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.HERBLORE, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.PRAYER, true)));
        this.skillsBar.getChildren().add(new ImageComponent(this.iconManager.getSkillImage(Skill.SMITHING, true)));
    }

    private void setPotentialLevels(ItemDataCache.SkillContents[] skillContents) {
        potentialLvlUps.put("construction", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.CONSTRUCTION) + (int)Math.ceil(skillContents[0].total))) - this.client.getRealSkillLevel(Skill.CONSTRUCTION)));
        potentialLvlUps.put("cooking", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.COOKING) + (int)Math.ceil(skillContents[1].total))) - this.client.getRealSkillLevel(Skill.COOKING)));
        potentialLvlUps.put("crafting", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.CRAFTING) + (int)Math.ceil(skillContents[2].total))) - this.client.getRealSkillLevel(Skill.CRAFTING)));
        potentialLvlUps.put("farming", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.FARMING) + (int)Math.ceil(skillContents[3].total))) - this.client.getRealSkillLevel(Skill.FARMING)));
        potentialLvlUps.put("firemaking", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.FIREMAKING) + (int)Math.ceil(skillContents[4].total))) - this.client.getRealSkillLevel(Skill.FIREMAKING)));
        potentialLvlUps.put("fletching", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.FLETCHING) + (int)Math.ceil(skillContents[5].total))) - this.client.getRealSkillLevel(Skill.FLETCHING)));
        potentialLvlUps.put("herblore", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.HERBLORE) + (int)Math.ceil(skillContents[6].total))) - this.client.getRealSkillLevel(Skill.HERBLORE)));
        potentialLvlUps.put("prayer", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.PRAYER) + (int)Math.ceil(skillContents[7].total))) - this.client.getRealSkillLevel(Skill.PRAYER)));
        potentialLvlUps.put("smithing", this.colorLvlUps(Experience.getLevelForXp((int)(this.client.getSkillExperience(Skill.SMITHING) + (int)Math.ceil(skillContents[8].total))) - this.client.getRealSkillLevel(Skill.SMITHING)));
    }

    private String colorLvlUps(int num) {
        if (num > 0) {
            return ColorUtil.wrapWithColorTag((String)("+" + num), (Color)Color.GREEN);
        }
        return "" + num;
    }

    private void createTooltips(ItemDataCache.SkillContents[] skillContents) {
        if (itemPanels.size() != 0) {
            itemPanels.clear();
        }
        for (int i = 0; i < skillContents.length; ++i) {
            PanelComponent panel = new PanelComponent();
            panel.setOrientation(ComponentOrientation.HORIZONTAL);
            panel.setPreferredSize(new Dimension(250, 0));
            panel.setWrap(true);
            for (int j = 0; j < skillContents[i].images.size(); ++j) {
                panel.getChildren().add((LayoutableRenderableEntity)skillContents[i].images.get(j));
            }
            itemPanels.add(panel);
        }
    }

    private Rectangle2D[] createBounds(Graphics2D graphics, int x, int y) {
        Rectangle2D[] bounds = new Rectangle2D[9];
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = new Rectangle2D.Double(x, y, 22.0, 25.0);
            x += 22;
        }
        return bounds;
    }

    private void setBounds(Graphics2D graphics, Point cursor, int x, int y) {
        Rectangle2D[] bounds = this.createBounds(graphics, x, y);
        if (bounds[0].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(0).getChildren().size() != 0) {
                String tooltip = xpTotals[0] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("construction");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Construction: ", (Color)SkillColor.CONSTRUCTION.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(0)));
            } else {
                this.tooltipManager.add(new Tooltip("Construction: " + xpTotals[0]));
            }
        } else if (bounds[1].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(1).getChildren().size() != 0) {
                String tooltip = xpTotals[1] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("cooking");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Cooking: ", (Color)SkillColor.COOKING.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(1)));
            } else {
                this.tooltipManager.add(new Tooltip("Cooking: " + xpTotals[1]));
            }
        } else if (bounds[2].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(2).getChildren().size() != 0) {
                String tooltip = xpTotals[2] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("crafting");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Crafting: ", (Color)SkillColor.CRAFTING.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(2)));
            } else {
                this.tooltipManager.add(new Tooltip("Crafting: " + xpTotals[2]));
            }
        } else if (bounds[3].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(3).getChildren().size() != 0) {
                String tooltip = xpTotals[3] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("farming");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Farming: ", (Color)SkillColor.FARMING.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(3)));
            } else {
                this.tooltipManager.add(new Tooltip("Farming: " + xpTotals[3]));
            }
        } else if (bounds[4].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(4).getChildren().size() != 0) {
                String tooltip = xpTotals[4] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("firemaking");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Firemaking: ", (Color)new Color(255, 119, 0)) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(4)));
            } else {
                this.tooltipManager.add(new Tooltip("Firemaking: " + xpTotals[4]));
            }
        } else if (bounds[5].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(5).getChildren().size() != 0) {
                String tooltip = xpTotals[5] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("fletching");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Fletching: ", (Color)SkillColor.FLETCHING.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(5)));
            } else {
                this.tooltipManager.add(new Tooltip("Fletching: " + xpTotals[5]));
            }
        } else if (bounds[6].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(6).getChildren().size() != 0) {
                String tooltip = xpTotals[6] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("herblore");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Herblore: ", (Color)SkillColor.HERBLORE.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(6)));
            } else {
                this.tooltipManager.add(new Tooltip("Herblore: " + xpTotals[6]));
            }
        } else if (bounds[7].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(7).getChildren().size() != 0) {
                String tooltip = xpTotals[7] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("prayer");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Prayer: ", (Color)SkillColor.PRAYER.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(7)));
            } else {
                this.tooltipManager.add(new Tooltip("Prayer: " + xpTotals[7]));
            }
        } else if (bounds[8].contains(cursor.getX(), cursor.getY())) {
            this.tooltipManager.clear();
            if (itemPanels.get(8).getChildren().size() != 0) {
                String tooltip = xpTotals[8] + "xp";
                if (this.config.potentialLevels()) {
                    tooltip = tooltip + "  |  Level-Ups: " + potentialLvlUps.get("smithing");
                }
                tooltip = ColorUtil.wrapWithColorTag((String)"Smithing: ", (Color)SkillColor.SMITHING.getColor().brighter().brighter()) + tooltip;
                this.tooltipManager.add(new Tooltip(tooltip));
                this.tooltipManager.add(new Tooltip((LayoutableRenderableEntity)itemPanels.get(8)));
            } else {
                this.tooltipManager.add(new Tooltip("Smithing: " + xpTotals[8]));
            }
        }
    }
}

