/*
 * Decompiled with CFR 0.152.
 */
package com.bankxpvalue;

import com.bankxpvalue.BankXpValueConfig;
import com.bankxpvalue.ItemDataCache;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.SkillColor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.QuantityFormatter;

public class BankXpValueItemOverlay
extends Overlay {
    private final Client client;
    private final BankXpValueConfig config;
    private final TooltipManager tooltipManager;
    @Inject
    ItemDataCache data;

    @Inject
    BankXpValueItemOverlay(Client client, BankXpValueConfig config, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.client = client;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showItemXpTooltips() || this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length - 1 < 0) {
            return null;
        }
        ItemContainer bank = this.client.getItemContainer(InventoryID.BANK);
        MenuEntry menuEntry = menuEntries[menuEntries.length - 1];
        int widgetId = menuEntry.getParam1();
        if (widgetId != WidgetInfo.BANK_ITEM_CONTAINER.getId()) {
            return null;
        }
        int index = menuEntry.getParam0();
        if (null == bank.getItem(index)) {
            return null;
        }
        Item item = bank.getItem(index);
        StringBuilder xpValue = new StringBuilder();
        try {
            if (null != this.data.getItem(item.getId())) {
                ItemDataCache.ItemData itemData = this.data.getItem(item.getId());
                xpValue.append(this.getColoredSkill(itemData.skill.substring(0, 1).toUpperCase() + itemData.skill.substring(1) + ": "));
                xpValue.append(QuantityFormatter.quantityToStackSize((long)((long)(itemData.xp * (double)item.getQuantity()))));
                xpValue.append(" xp (" + QuantityFormatter.formatNumber((double)itemData.xp) + " ea)");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!xpValue.toString().equals("")) {
            this.tooltipManager.add(new Tooltip(xpValue.toString()));
        }
        return null;
    }

    private String getColoredSkill(String skill) {
        switch (skill) {
            case "Construction: ": {
                return ColorUtil.wrapWithColorTag((String)"Construction: ", (Color)SkillColor.CONSTRUCTION.getColor().brighter().brighter());
            }
            case "Cooking: ": {
                return ColorUtil.wrapWithColorTag((String)"Cooking: ", (Color)SkillColor.COOKING.getColor().brighter().brighter());
            }
            case "Crafting: ": {
                return ColorUtil.wrapWithColorTag((String)"Crafting: ", (Color)SkillColor.CRAFTING.getColor().brighter().brighter());
            }
            case "Farming: ": {
                return ColorUtil.wrapWithColorTag((String)"Farming: ", (Color)SkillColor.FARMING.getColor().brighter().brighter());
            }
            case "Firemaking: ": {
                return ColorUtil.wrapWithColorTag((String)"Firemaking: ", (Color)new Color(255, 119, 0));
            }
            case "Fletching: ": {
                return ColorUtil.wrapWithColorTag((String)"Fletching: ", (Color)SkillColor.FLETCHING.getColor().brighter().brighter());
            }
            case "Herblore: ": {
                return ColorUtil.wrapWithColorTag((String)"Herblore: ", (Color)SkillColor.HERBLORE.getColor().brighter().brighter());
            }
            case "Prayer: ": {
                return ColorUtil.wrapWithColorTag((String)"Prayer: ", (Color)SkillColor.PRAYER.getColor().brighter().brighter());
            }
            case "Smithing: ": {
                return ColorUtil.wrapWithColorTag((String)"Smithing: ", (Color)SkillColor.SMITHING.getColor().brighter().brighter());
            }
        }
        return skill;
    }
}

