/*
 * Decompiled with CFR 0.152.
 */
package com.strongholdofsecurity;

import com.strongholdofsecurity.SecurityAnswers;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Stronghold of Security Helper", enabledByDefault=false)
public class StrongholdOfSecurityPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StrongholdOfSecurityPlugin.class);
    private static final Color ANSWER_COLOR = new Color(0, 19, 230);
    @Inject
    private Client client;
    private boolean isNPCDialogueOpen;
    private boolean isNPCDialogOptionOpen;
    private String question;

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        switch (widgetLoaded.getGroupId()) {
            case 231: {
                this.isNPCDialogueOpen = true;
                break;
            }
            case 219: {
                this.isNPCDialogOptionOpen = true;
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick t) {
        if (this.isNPCDialogueOpen) {
            this.isNPCDialogueOpen = false;
            this.onNPCDialogue();
        }
        if (this.isNPCDialogOptionOpen) {
            this.isNPCDialogOptionOpen = false;
            this.onNPCOption();
        }
    }

    private void onNPCDialogue() {
        String npcText;
        Widget debugWidget = this.client.getWidget(WidgetInfo.DIALOG_NPC_TEXT);
        if (debugWidget != null && SecurityAnswers.QUESTION_ANSWER_MAP.containsKey(npcText = debugWidget.getText())) {
            this.question = npcText;
        }
    }

    private void onNPCOption() {
        Widget[] widgets;
        Widget optionsWidget;
        if (this.question != null && (optionsWidget = this.client.getWidget(WidgetInfo.DIALOG_OPTION)) != null && (widgets = optionsWidget.getParent().getChildren()) != null) {
            Widget answerWidget = SecurityAnswers.findMatchingWidgetForQuestion(this.question, widgets);
            this.question = null;
            if (answerWidget != null) {
                String answerText = String.format("(%d) %s", answerWidget.getIndex(), answerWidget.getText());
                answerWidget.setText(ColorUtil.wrapWithColorTag((String)answerText, (Color)ANSWER_COLOR));
            }
        }
    }
}

