/*
 * Decompiled with CFR 0.152.
 */
package com.blackjack;

import com.blackjack.BlackjackConfig;
import com.blackjack.BlackjackOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.WildcardMatcher;

@PluginDescriptor(name="Blackjack", description="Help show whether a blackjack target is knocked out or not", tags={"blackjack", "thieve", "thieving"})
public class BlackjackPlugin
extends Plugin {
    private static final String SUCCESS_BLACKJACK = "You smack the bandit over the head and render them unconscious.";
    @Inject
    private BlackjackConfig blackjackConfig;
    @Inject
    private BlackjackOverlay blackjackOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    private final Set<NPC> highlightedNpcs = new HashSet<NPC>();
    private boolean knockedOut = false;
    private String highlight = "";
    private long nextKnockOutTick = 0L;

    @Provides
    BlackjackConfig provideConfig(ConfigManager configManager) {
        return (BlackjackConfig)configManager.getConfig(BlackjackConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.blackjackOverlay);
        this.highlight = this.npcToHighlight();
        this.clientThread.invoke(() -> this.rebuildAllNpcs());
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.blackjackOverlay);
        this.highlightedNpcs.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.highlightedNpcs.clear();
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("blackjack")) {
            return;
        }
        this.highlight = this.npcToHighlight();
        this.rebuildAllNpcs();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (WildcardMatcher.matches((String)this.highlight, (String)npcName)) {
            this.highlightedNpcs.add(npc);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.highlightedNpcs.remove(npc);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if ((long)this.client.getTickCount() >= this.nextKnockOutTick) {
            this.knockedOut = false;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String msg = event.getMessage();
        if (event.getType() == ChatMessageType.SPAM && msg.equals(SUCCESS_BLACKJACK)) {
            this.knockedOut = true;
            this.nextKnockOutTick = this.client.getTickCount() + 4;
        }
    }

    public Color getHighlightColor() {
        return this.knockedOut ? this.blackjackConfig.knockedOutStateColor() : this.blackjackConfig.awakeStateColor();
    }

    private String npcToHighlight() {
        switch (this.blackjackConfig.npcToBlackjack()) {
            case BANDIT: {
                return "Bandit";
            }
            case MENAPHITE_THUG: {
                return "Menaphite Thug";
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.blackjackConfig.npcToBlackjack());
    }

    private void rebuildAllNpcs() {
        this.highlightedNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null || !WildcardMatcher.matches((String)this.highlight, (String)npcName)) continue;
            this.highlightedNpcs.add(npc);
        }
    }

    public String statusText() {
        return this.isKnockedOut() ? "Knocked-out" : "Awake";
    }

    Set<NPC> getHighlightedNpcs() {
        return this.highlightedNpcs;
    }

    boolean isKnockedOut() {
        return this.knockedOut;
    }
}

