/*
 * Decompiled with CFR 0.152.
 */
package com.blackjack;

import com.blackjack.BlackjackConfig;
import com.blackjack.BlackjackPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.Text;

public class BlackjackOverlay
extends Overlay {
    private final Client client;
    private final BlackjackConfig config;
    private final BlackjackPlugin plugin;

    @Inject
    BlackjackOverlay(Client client, BlackjackConfig config, BlackjackPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        for (NPC npc : this.plugin.getHighlightedNpcs()) {
            this.renderNpcOverlay(graphics, npc, this.plugin.getHighlightColor());
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC actor, Color color) {
        String npcName;
        Point textLocation;
        NPCComposition npcComposition = actor.getTransformedComposition();
        if (npcComposition == null || !npcComposition.isInteractible()) {
            return;
        }
        switch (this.config.renderStyle()) {
            case TILE: {
                int size = npcComposition.getSize();
                LocalPoint lp = actor.getLocalLocation();
                Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp, (int)size);
                this.renderPoly(graphics, color, tilePoly);
                break;
            }
            case HULL: {
                Shape objectClickbox = actor.getConvexHull();
                this.renderPoly(graphics, color, objectClickbox);
            }
        }
        if (this.config.statusText() && actor.getName() != null && (textLocation = actor.getCanvasTextLocation(graphics, npcName = Text.removeTags((String)actor.getName()), actor.getLogicalHeight() + 40)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)this.plugin.statusText(), (Color)color);
        }
    }

    private void renderPoly(Graphics2D graphics, Color color, Shape polygon) {
        if (polygon != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.draw(polygon);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 20));
            graphics.fill(polygon);
        }
    }
}

