/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.state;

import com.tobmistaketracker.TobMistake;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class PlayerTrackingInfo {
    @NonNull
    private final String playerName;
    @NonNull
    private final Map<TobMistake, Integer> mistakes;
    private int raidCount;

    public PlayerTrackingInfo(@NonNull String playerName) {
        if (playerName == null) {
            throw new NullPointerException("playerName is marked @NonNull but is null");
        }
        this.playerName = playerName;
        this.mistakes = new HashMap<TobMistake, Integer>();
        this.raidCount = 1;
    }

    public void incrementMistake(TobMistake mistake) {
        this.mistakes.compute(mistake, PlayerTrackingInfo::increment);
    }

    public void incrementRaidCount() {
        ++this.raidCount;
    }

    public boolean hasMistakes() {
        return !this.mistakes.isEmpty();
    }

    private static <T> Integer increment(T key, Integer oldValue) {
        return oldValue == null ? 1 : oldValue + 1;
    }

    @NonNull
    public String getPlayerName() {
        return this.playerName;
    }

    @NonNull
    public Map<TobMistake, Integer> getMistakes() {
        return this.mistakes;
    }

    public int getRaidCount() {
        return this.raidCount;
    }
}

