/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.state;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.tobmistaketracker.state.MistakeStateManager;
import com.tobmistaketracker.state.MistakeStateUtil;
import com.tobmistaketracker.state.MistakeStateWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MistakeStateReader {
    private static final Logger log = LoggerFactory.getLogger(MistakeStateReader.class);
    private static final Gson GSON = RuneLiteAPI.GSON;
    private final MistakeStateWriter mistakeStateWriter;
    private final Path mistakeStateFilePath;

    @Inject
    public MistakeStateReader(MistakeStateWriter mistakeStateWriter, @Named(value="developerMode") boolean developerMode) {
        this.mistakeStateWriter = mistakeStateWriter;
        this.mistakeStateFilePath = MistakeStateUtil.getMistakeStateFilePath(developerMode);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public MistakeStateManager read() {
        if (Files.exists(this.mistakeStateFilePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.mistakeStateFilePath);){
                MistakeStateManager mistakeStateManager;
                JsonReader jsonReader;
                block16: {
                    MistakeStateManager mistakeStateManager2;
                    jsonReader = new JsonReader((Reader)reader);
                    try {
                        mistakeStateManager = (MistakeStateManager)GSON.fromJson(jsonReader, MistakeStateManager.class);
                        if (mistakeStateManager != null) break block16;
                        mistakeStateManager2 = new MistakeStateManager(this.mistakeStateWriter);
                    }
                    catch (Throwable throwable) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    jsonReader.close();
                    return mistakeStateManager2;
                }
                mistakeStateManager.setMistakeStateWriter(this.mistakeStateWriter);
                MistakeStateManager mistakeStateManager3 = mistakeStateManager;
                jsonReader.close();
                return mistakeStateManager3;
            }
            catch (JsonSyntaxException | IOException e) {
                log.error("Unable to read mistake state from " + this.mistakeStateFilePath, e);
            }
        }
        return new MistakeStateManager(this.mistakeStateWriter);
    }
}

