/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.state;

import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.state.MistakeManager;
import com.tobmistaketracker.state.MistakeStateWriter;
import java.util.Set;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MistakeStateManager {
    private static final Logger log = LoggerFactory.getLogger(MistakeStateManager.class);
    private final MistakeManager currentRaidMistakeManager = new MistakeManager();
    private final MistakeManager allRaidsMistakeManager = new MistakeManager();
    private transient boolean isAll;
    private transient MistakeStateWriter mistakeStateWriter;

    public MistakeStateManager(MistakeStateWriter mistakeStateWriter) {
        this.mistakeStateWriter = mistakeStateWriter;
        this.isAll = false;
    }

    public void addMistakeForPlayer(String playerName, TobMistake mistake) {
        this.currentRaidMistakeManager.addMistakeForPlayer(playerName, mistake);
        this.allRaidsMistakeManager.addMistakeForPlayer(playerName, mistake);
        this.mistakeStateWriter.write(this);
    }

    public void removeAllMistakesForPlayer(String playerName) {
        this.currentRaidMistakeManager.removeAllMistakesForPlayer(playerName);
        this.allRaidsMistakeManager.removeAllMistakesForPlayer(playerName);
        this.mistakeStateWriter.write(this);
    }

    public void resetAll() {
        this.currentRaidMistakeManager.clearAllMistakes();
        this.allRaidsMistakeManager.clearAllMistakes();
        this.mistakeStateWriter.write(this);
    }

    public void newRaid(Set<String> playerNames) {
        this.currentRaidMistakeManager.clearAllMistakes();
        this.allRaidsMistakeManager.newRaid(playerNames);
        this.mistakeStateWriter.write(this);
    }

    public Set<String> getPlayersWithMistakes() {
        return this.isAll ? this.allRaidsMistakeManager.getPlayersWithMistakes() : this.currentRaidMistakeManager.getPlayersWithMistakes();
    }

    public int getMistakeCountForPlayer(String playerName, TobMistake mistake) {
        return this.isAll ? this.allRaidsMistakeManager.getMistakeCountForPlayer(playerName, mistake) : this.currentRaidMistakeManager.getMistakeCountForPlayer(playerName, mistake);
    }

    public int getTotalMistakeCountForAllPlayers() {
        return this.isAll ? this.allRaidsMistakeManager.getTotalMistakeCountForAllPlayers() : this.currentRaidMistakeManager.getTotalMistakeCountForAllPlayers();
    }

    public int getRaidCountForPlayer(String playerName) {
        return this.isAll ? this.allRaidsMistakeManager.getRaidCountForPlayer(playerName) : 0;
    }

    public int getTrackedRaids() {
        return this.isAll ? this.allRaidsMistakeManager.getTrackedRaids() : 1;
    }

    public void switchMistakes() {
        this.isAll = !this.isAll;
    }

    public void setMistakeStateWriter(MistakeStateWriter mistakeStateWriter) {
        this.mistakeStateWriter = mistakeStateWriter;
    }
}

