/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.panel;

import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobMistakeTrackerPlugin;
import com.tobmistaketracker.panel.PlayerMistakesBox;
import com.tobmistaketracker.state.MistakeStateManager;
import com.tobmistaketracker.state.MistakeStateReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.SwingUtil;

@Singleton
public class TobMistakeTrackerPanel
extends PluginPanel {
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private static final boolean DEFAULT_IS_RAID_DEATHS = false;
    private static final ImageIcon RAID_DEATHS_ICON;
    private static final ImageIcon RAID_DEATHS_ICON_FADED;
    private static final ImageIcon RAID_DEATHS_ICON_HOVER;
    private static final ImageIcon ROOM_DEATHS_ICON;
    private static final ImageIcon ROOM_DEATHS_ICON_FADED;
    private static final ImageIcon ROOM_DEATHS_ICON_HOVER;
    private final Client client;
    private final MistakeStateManager mistakeStateManager;
    private List<String> currentRaiderNames;
    private final JLabel currentViewTitle = new JLabel();
    private final JButton switchMistakesViewBtn = new JButton();
    private final JRadioButton raidDeathsBtn = new JRadioButton();
    private final JRadioButton roomDeathsBtn = new JRadioButton();
    private final JPanel overallPanel = new JPanel();
    private final JLabel overallPlayersLabel = new JLabel();
    private final JLabel overallMistakesLabel = new JLabel();
    private final JLabel overallRaidsLabel = new JLabel();
    private final JLabel overallIcon = new JLabel();
    private final JPanel mistakesContainer = new JPanel();
    private final List<PlayerMistakesBox> playerMistakesBoxes = new ArrayList<PlayerMistakesBox>();
    private boolean isRaidDeaths;
    private boolean isShowingAll = false;
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();

    @Inject
    public TobMistakeTrackerPanel(Client client, MistakeStateReader mistakeStateReader, @Named(value="developerMode") boolean developerMode) {
        this.client = client;
        this.mistakeStateManager = mistakeStateReader.read();
        this.currentRaiderNames = Collections.emptyList();
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        this.add(layoutPanel, "North");
        JPanel headerContainer = new JPanel(new GridLayout(2, 1, 0, 0));
        headerContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel viewContainer = new JPanel(new BorderLayout());
        viewContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        viewContainer.setPreferredSize(new Dimension(0, 30));
        viewContainer.setBorder(new EmptyBorder(5, 5, 5, 10));
        JPanel leftTitleContainer = new JPanel(new BorderLayout(5, 0));
        leftTitleContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.currentViewTitle.setForeground(Color.WHITE);
        this.currentViewTitle.setText(this.getCurrentViewTitleText());
        leftTitleContainer.add((Component)this.currentViewTitle, "West");
        SwingUtil.removeButtonDecorations((AbstractButton)this.switchMistakesViewBtn);
        this.switchMistakesViewBtn.setText(this.getSwitchMistakesViewButtonText());
        this.switchMistakesViewBtn.setBackground(Color.WHITE);
        this.switchMistakesViewBtn.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.switchMistakesViewBtn.setBorderPainted(true);
        this.switchMistakesViewBtn.setPreferredSize(new Dimension(100, 10));
        this.switchMistakesViewBtn.addActionListener(e -> this.switchMistakesView());
        this.switchMistakesViewBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TobMistakeTrackerPanel.this.switchMistakesViewBtn.setForeground(Color.LIGHT_GRAY);
                TobMistakeTrackerPanel.this.switchMistakesViewBtn.setBackground(Color.LIGHT_GRAY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TobMistakeTrackerPanel.this.switchMistakesViewBtn.setForeground(Color.WHITE);
                TobMistakeTrackerPanel.this.switchMistakesViewBtn.setBackground(Color.WHITE);
            }
        });
        viewContainer.add((Component)leftTitleContainer, "West");
        viewContainer.add((Component)this.switchMistakesViewBtn, "East");
        headerContainer.add(viewContainer);
        JPanel actionButtons = new JPanel(new FlowLayout(2, 0, 0));
        actionButtons.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        actionButtons.setPreferredSize(new Dimension(0, 30));
        actionButtons.setBorder(new EmptyBorder(5, 5, 5, 10));
        SwingUtil.removeButtonDecorations((AbstractButton)this.raidDeathsBtn);
        this.raidDeathsBtn.setIcon(RAID_DEATHS_ICON_FADED);
        this.raidDeathsBtn.setRolloverIcon(RAID_DEATHS_ICON_HOVER);
        this.raidDeathsBtn.setSelectedIcon(RAID_DEATHS_ICON);
        this.raidDeathsBtn.setToolTipText("Group all raid deaths into a singular mistake");
        this.raidDeathsBtn.addActionListener(e -> this.changeDeathGrouping(true));
        SwingUtil.removeButtonDecorations((AbstractButton)this.roomDeathsBtn);
        this.roomDeathsBtn.setIcon(ROOM_DEATHS_ICON_FADED);
        this.roomDeathsBtn.setRolloverIcon(ROOM_DEATHS_ICON_HOVER);
        this.roomDeathsBtn.setSelectedIcon(ROOM_DEATHS_ICON);
        this.roomDeathsBtn.setToolTipText("Show each room's deaths as their own mistakes");
        this.roomDeathsBtn.addActionListener(e -> this.changeDeathGrouping(false));
        ButtonGroup raidRoomGroup = new ButtonGroup();
        raidRoomGroup.add(this.raidDeathsBtn);
        raidRoomGroup.add(this.roomDeathsBtn);
        actionButtons.add(this.raidDeathsBtn);
        actionButtons.add(this.roomDeathsBtn);
        headerContainer.add(actionButtons);
        this.changeDeathGrouping(false);
        headerContainer.setVisible(true);
        this.overallPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        this.overallPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.overallPanel.setLayout(new BorderLayout());
        JPanel overallInfo = new JPanel();
        overallInfo.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        overallInfo.setLayout(new GridLayout(3, 1));
        overallInfo.setBorder(new EmptyBorder(2, 10, 2, 0));
        this.overallPlayersLabel.setFont(FontManager.getRunescapeSmallFont());
        this.overallMistakesLabel.setFont(FontManager.getRunescapeSmallFont());
        this.overallRaidsLabel.setFont(FontManager.getRunescapeSmallFont());
        overallInfo.add(this.overallPlayersLabel);
        overallInfo.add(this.overallMistakesLabel);
        overallInfo.add(this.overallRaidsLabel);
        this.overallPanel.add((Component)this.overallIcon, "West");
        this.overallPanel.add((Component)overallInfo, "Center");
        JMenuItem reset = new JMenuItem("Reset All");
        reset.addActionListener(e -> {
            int result = JOptionPane.showOptionDialog(this.overallPanel, "This will permanently delete ALL mistakes across ALL raids from the client.", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (result != 0) {
                return;
            }
            this.resetAll();
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(reset);
        this.overallPanel.setComponentPopupMenu(popupMenu);
        this.mistakesContainer.setLayout(new BoxLayout(this.mistakesContainer, 1));
        layoutPanel.add(headerContainer);
        layoutPanel.add(this.overallPanel);
        layoutPanel.add(this.mistakesContainer);
        if (developerMode) {
            JButton testButton = new JButton("Test Mistakes");
            testButton.addActionListener(e -> {
                for (TobMistake mistake : TobMistake.values()) {
                    this.addMistakeForPlayer("Test Player", mistake);
                }
            });
            layoutPanel.add(testButton);
        }
        this.errorPanel.setContent("Tob Mistake Tracker", "You have not tracked any mistakes yet.");
        this.updateVisiblePanels(true);
    }

    public void reload() {
        this.rebuildAll();
    }

    public void loadHeaderIcon(BufferedImage img) {
        this.overallIcon.setIcon(new ImageIcon(img));
    }

    public void newRaid(List<String> playerNames) {
        this.currentRaiderNames = playerNames;
        this.mistakeStateManager.newRaid(new HashSet<String>(playerNames));
        if (this.isShowingAll) {
            this.updateOverallPanel();
            this.reorderRaiderBoxes();
        } else {
            this.resetUi();
        }
    }

    public void addMistakeForPlayer(String playerName, TobMistake mistake) {
        this.mistakeStateManager.addMistakeForPlayer(playerName, mistake);
        PlayerMistakesBox box = this.buildBox(playerName);
        box.rebuildAllMistakes(this.isRaidDeaths);
        this.updateOverallPanel();
        this.reorderRaiderBoxes();
    }

    private void rebuildAll() {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtil.fastRemoveAll((Container)this.mistakesContainer);
        } else {
            this.mistakesContainer.removeAll();
        }
        this.playerMistakesBoxes.clear();
        for (String playerName : this.mistakeStateManager.getPlayersWithMistakes()) {
            this.buildBox(playerName);
        }
        this.playerMistakesBoxes.forEach(box -> box.rebuildAllMistakes(this.isRaidDeaths));
        this.updateOverallPanel();
        this.reorderRaiderBoxes();
        this.mistakesContainer.revalidate();
        this.mistakesContainer.repaint();
        this.updateVisiblePanels(this.playerMistakesBoxes.isEmpty());
    }

    private PlayerMistakesBox buildBox(String playerName) {
        for (PlayerMistakesBox box : this.playerMistakesBoxes) {
            if (!box.getPlayerName().equals(playerName)) continue;
            return box;
        }
        PlayerMistakesBox box = new PlayerMistakesBox(this.mistakeStateManager, playerName);
        JPopupMenu popupMenu = box.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
            box.setComponentPopupMenu(popupMenu);
        }
        JMenuItem reset = new JMenuItem("Reset ALL Mistakes for " + playerName);
        reset.addActionListener(e -> {
            this.mistakeStateManager.removeAllMistakesForPlayer(playerName);
            this.playerMistakesBoxes.remove(box);
            this.updateOverallPanel();
            this.mistakesContainer.remove(box);
            this.mistakesContainer.repaint();
            if (this.playerMistakesBoxes.isEmpty()) {
                this.updateVisiblePanels(true);
            }
        });
        popupMenu.add(reset);
        this.updateVisiblePanels(false);
        this.mistakesContainer.add(box);
        this.playerMistakesBoxes.add(box);
        return box;
    }

    private void reorderRaiderBoxes() {
        Map<String, PlayerMistakesBox> playerNameToBox = this.playerMistakesBoxes.stream().collect(Collectors.toMap(PlayerMistakesBox::getPlayerName, e -> e));
        for (int i = this.currentRaiderNames.size() - 1; i >= 0; --i) {
            PlayerMistakesBox box = playerNameToBox.get(this.currentRaiderNames.get(i));
            if (box == null) continue;
            this.moveBoxToTop(box);
        }
        if (this.client.getLocalPlayer() != null && playerNameToBox.get(this.client.getLocalPlayer().getName()) != null) {
            PlayerMistakesBox box = playerNameToBox.get(this.client.getLocalPlayer().getName());
            this.moveBoxToTop(box);
        }
    }

    private void resetAll() {
        this.mistakeStateManager.resetAll();
        this.resetUi();
    }

    private void resetUi() {
        this.playerMistakesBoxes.clear();
        this.updateOverallPanel();
        this.mistakesContainer.removeAll();
        this.mistakesContainer.repaint();
        this.updateVisiblePanels(true);
    }

    private void updateOverallPanel() {
        this.overallPlayersLabel.setText(TobMistakeTrackerPanel.htmlLabel("Total players: ", this.mistakeStateManager.getPlayersWithMistakes().size()));
        this.overallMistakesLabel.setText(TobMistakeTrackerPanel.htmlLabel("Total mistakes: ", this.mistakeStateManager.getTotalMistakeCountForAllPlayers()));
        this.overallRaidsLabel.setText(TobMistakeTrackerPanel.htmlLabel("Tracked raids: ", this.mistakeStateManager.getTrackedRaids()));
    }

    private static String htmlLabel(String key, long value) {
        String valueStr = QuantityFormatter.quantityToStackSize((long)value);
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    private boolean doesLocalPlayerHaveMistakesBox() {
        if (this.client.getLocalPlayer() != null) {
            String name = this.client.getLocalPlayer().getName();
            return this.playerMistakesBoxes.stream().anyMatch(b -> b.getPlayerName().equals(name));
        }
        return false;
    }

    private void moveBoxToTop(PlayerMistakesBox box) {
        this.mistakesContainer.setComponentZOrder(box, 0);
    }

    private void updateVisiblePanels(boolean isEmpty) {
        if (isEmpty) {
            this.add((Component)this.errorPanel);
            this.overallPanel.setVisible(false);
            this.mistakesContainer.setVisible(false);
        } else {
            this.remove((Component)this.errorPanel);
            this.overallPanel.setVisible(true);
            this.mistakesContainer.setVisible(true);
        }
    }

    private void changeDeathGrouping(boolean isRaid) {
        this.isRaidDeaths = isRaid;
        (isRaid ? this.raidDeathsBtn : this.roomDeathsBtn).setSelected(true);
        this.rebuildAll();
    }

    private void switchMistakesView() {
        this.isShowingAll = !this.isShowingAll;
        this.currentViewTitle.setText(this.getCurrentViewTitleText());
        this.switchMistakesViewBtn.setText(this.getSwitchMistakesViewButtonText());
        this.mistakeStateManager.switchMistakes();
        this.rebuildAll();
    }

    private String getCurrentViewTitleText() {
        return this.isShowingAll ? "All Raids" : "Current Raid";
    }

    private String getSwitchMistakesViewButtonText() {
        return this.isShowingAll ? "Show Current" : "Show All";
    }

    static {
        BufferedImage raidDeathsImg = ImageUtil.loadImageResource(TobMistakeTrackerPlugin.class, (String)"raid_deaths.png");
        BufferedImage roomDeathsImg = ImageUtil.loadImageResource(TobMistakeTrackerPlugin.class, (String)"room_deaths.png");
        RAID_DEATHS_ICON = new ImageIcon(raidDeathsImg);
        RAID_DEATHS_ICON_FADED = new ImageIcon(ImageUtil.alphaOffset((Image)raidDeathsImg, (int)-180));
        RAID_DEATHS_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)raidDeathsImg, (int)-220));
        ROOM_DEATHS_ICON = new ImageIcon(roomDeathsImg);
        ROOM_DEATHS_ICON_FADED = new ImageIcon(ImageUtil.alphaOffset((Image)roomDeathsImg, (int)-180));
        ROOM_DEATHS_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)roomDeathsImg, (int)-220));
    }
}

