/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.google.common.annotations.VisibleForTesting;
import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.BaseTobMistakeDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VerzikP3MistakeDetector
extends BaseTobMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(VerzikP3MistakeDetector.class);
    private static final Set<Integer> VERZIK_P3_IDS = Set.of(Integer.valueOf(10835), Integer.valueOf(8374), Integer.valueOf(10852));
    private static final int VERZIK_WEB_GAME_OBJECT_ID = 32734;
    private static final int PLAYER_PURPLE_GRAPHIC_ID = 1602;
    private final Set<WorldPoint> activeWebTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> webTilesToRemove = new HashSet<WorldPoint>();
    private final Set<String> playerNamesPurpled = new HashSet<String>();

    @Inject
    public VerzikP3MistakeDetector() {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.activeWebTiles.clear();
        this.webTilesToRemove.clear();
        this.playerNamesPurpled.clear();
    }

    @Override
    protected void computeDetectingMistakes() {
        if (!this.detectingMistakes && this.isAlreadySpawned()) {
            this.detectingMistakes = true;
        }
    }

    @Override
    public List<TobMistake> detectMistakes(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        ArrayList<TobMistake> mistakes = new ArrayList<TobMistake>();
        if (raider.isDead()) {
            return mistakes;
        }
        if (this.webTilesToRemove.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(TobMistake.VERZIK_P3_WEB);
        }
        if (this.playerNamesPurpled.contains(raider.getName())) {
            mistakes.add(TobMistake.VERZIK_P3_PURPLE);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.activeWebTiles.removeAll(this.webTilesToRemove);
        this.webTilesToRemove.clear();
        this.playerNamesPurpled.clear();
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        if (event.getActor() instanceof Player && event.getActor().getGraphic() == 1602) {
            this.playerNamesPurpled.add(event.getActor().getName());
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.detectingMistakes && VerzikP3MistakeDetector.isVerzikP3(event.getNpc())) {
            this.detectingMistakes = true;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (event.getGameObject().getId() == 32734) {
            this.activeWebTiles.add(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (event.getGameObject().getId() == 32734) {
            this.webTilesToRemove.add(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        if (!this.detectingMistakes && VerzikP3MistakeDetector.isVerzikP3(event.getNpc())) {
            this.detectingMistakes = true;
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        if (event.getActor() instanceof NPC && VerzikP3MistakeDetector.isVerzikP3((NPC)event.getActor())) {
            this.shutdown();
        }
    }

    private boolean isAlreadySpawned() {
        return this.client.getNpcs().stream().anyMatch(VerzikP3MistakeDetector::isVerzikP3);
    }

    private static boolean isVerzikP3(NPC npc) {
        return "Verzik Vitur".equals(npc.getName()) && VERZIK_P3_IDS.contains(npc.getId());
    }

    @VisibleForTesting
    public Set<WorldPoint> getVerzikP3WebTiles() {
        return Collections.unmodifiableSet(this.activeWebTiles);
    }
}

