/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.google.common.annotations.VisibleForTesting;
import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.BaseTobMistakeDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VerzikP2MistakeDetector
extends BaseTobMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(VerzikP2MistakeDetector.class);
    private static final int VERZIK_BOMB_GRAPHICS_OBJECT_ID = 1584;
    private static final int PLAYER_BOUNCE_ANIMATION_ID = 1157;
    private static final int VERZIK_ACID_GAME_OBJECT_ID = 41747;
    private static final Set<Integer> VERZIK_P2_IDS = Set.of(Integer.valueOf(10833), Integer.valueOf(8372), Integer.valueOf(10850));
    private final Set<WorldPoint> activeBombTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> activeAcidTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> acidTilesToRemove = new HashSet<WorldPoint>();
    private final Set<String> playerNamesBounced = new HashSet<String>();

    @Inject
    public VerzikP2MistakeDetector() {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.activeBombTiles.clear();
        this.activeAcidTiles.clear();
        this.acidTilesToRemove.clear();
        this.playerNamesBounced.clear();
    }

    @Override
    protected void computeDetectingMistakes() {
        if (!this.detectingMistakes && this.isAlreadySpawned()) {
            this.detectingMistakes = true;
        }
    }

    @Override
    public List<TobMistake> detectMistakes(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        ArrayList<TobMistake> mistakes = new ArrayList<TobMistake>();
        if (raider.isDead()) {
            return mistakes;
        }
        if (this.activeAcidTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(TobMistake.VERZIK_P2_ACID);
        }
        if (this.activeBombTiles.contains(raider.getPreviousWorldLocation())) {
            mistakes.add(TobMistake.VERZIK_P2_BOMB);
        }
        if (this.playerNamesBounced.contains(raider.getName())) {
            mistakes.add(TobMistake.VERZIK_P2_BOUNCE);
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.activeBombTiles.clear();
        this.activeAcidTiles.removeAll(this.acidTilesToRemove);
        this.acidTilesToRemove.clear();
        this.playerNamesBounced.clear();
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        if (event.getGraphicsObject().getId() == 1584) {
            WorldPoint worldPoint = WorldPoint.fromLocal((Client)this.client, (LocalPoint)event.getGraphicsObject().getLocation());
            this.activeBombTiles.add(worldPoint);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (event.getGameObject().getId() == 41747) {
            this.activeAcidTiles.add(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (event.getGameObject().getId() == 41747) {
            this.acidTilesToRemove.add(event.getGameObject().getWorldLocation());
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() instanceof Player && event.getActor().getAnimation() == 1157) {
            this.playerNamesBounced.add(event.getActor().getName());
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.detectingMistakes && VerzikP2MistakeDetector.isVerzikP2(event.getNpc())) {
            this.detectingMistakes = true;
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        if (!this.detectingMistakes && VerzikP2MistakeDetector.isVerzikP2(event.getNpc())) {
            this.detectingMistakes = true;
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        if (event.getActor() instanceof NPC && VerzikP2MistakeDetector.isVerzikP2((NPC)event.getActor())) {
            this.shutdown();
        }
    }

    private boolean isAlreadySpawned() {
        return this.client.getNpcs().stream().anyMatch(VerzikP2MistakeDetector::isVerzikP2);
    }

    private static boolean isVerzikP2(NPC npc) {
        return "Verzik Vitur".equals(npc.getName()) && VERZIK_P2_IDS.contains(npc.getId());
    }

    @VisibleForTesting
    public Set<WorldPoint> getVerzikP2AcidTiles() {
        return Collections.unmodifiableSet(this.activeAcidTiles);
    }
}

