/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.google.common.annotations.VisibleForTesting;
import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.BaseTobMistakeDetector;
import com.tobmistaketracker.detector.BloatMistakeDetector;
import com.tobmistaketracker.detector.DeathMistakeDetector;
import com.tobmistaketracker.detector.MaidenMistakeDetector;
import com.tobmistaketracker.detector.VerzikP2MistakeDetector;
import com.tobmistaketracker.detector.VerzikP3MistakeDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MistakeDetectorManager {
    private static final Logger log = LoggerFactory.getLogger(MistakeDetectorManager.class);
    private final List<BaseTobMistakeDetector> mistakeDetectors;
    @VisibleForTesting
    private boolean started;

    @Inject
    public MistakeDetectorManager(DeathMistakeDetector deathMistakeDetector, MaidenMistakeDetector maidenMistakeDetector, BloatMistakeDetector bloatMistakeDetector, VerzikP2MistakeDetector verzikP2MistakeDetector, VerzikP3MistakeDetector verzikP3MistakeDetector) {
        this.mistakeDetectors = new ArrayList<BaseTobMistakeDetector>(Arrays.asList(maidenMistakeDetector, bloatMistakeDetector, verzikP2MistakeDetector, verzikP3MistakeDetector, deathMistakeDetector));
        this.started = false;
    }

    public void startup() {
        this.started = true;
        for (BaseTobMistakeDetector mistakeDetector : this.mistakeDetectors) {
            mistakeDetector.startup();
        }
    }

    public void shutdown() {
        this.started = false;
        for (BaseTobMistakeDetector mistakeDetector : this.mistakeDetectors) {
            mistakeDetector.shutdown();
        }
    }

    public List<TobMistake> detectMistakes(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        ArrayList<TobMistake> mistakes = new ArrayList<TobMistake>();
        if (!this.started) {
            return mistakes;
        }
        for (BaseTobMistakeDetector mistakeDetector : this.mistakeDetectors) {
            if (!mistakeDetector.isDetectingMistakes()) continue;
            mistakes.addAll(mistakeDetector.detectMistakes(raider));
        }
        return mistakes;
    }

    public void afterDetect() {
        if (!this.started) {
            return;
        }
        for (BaseTobMistakeDetector mistakeDetector : this.mistakeDetectors) {
            if (!mistakeDetector.isDetectingMistakes()) continue;
            mistakeDetector.afterDetect();
        }
    }

    public List<BaseTobMistakeDetector> getMistakeDetectors() {
        return Collections.unmodifiableList(this.mistakeDetectors);
    }

    public boolean isStarted() {
        return this.started;
    }
}

