/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.google.common.annotations.VisibleForTesting;
import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.BaseTobMistakeDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MaidenMistakeDetector
extends BaseTobMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(MaidenMistakeDetector.class);
    private static final int BLOOD_SPAWN_BLOOD_GAME_OBJECT_ID = 32984;
    private static final int MAIDEN_BLOOD_PROJECTILE_ID = 1578;
    private static final int CYCLES_PER_GAME_TICK = 30;
    private static final int MAIDEN_BLOOD_GAME_TICK_LENGTH = 11;
    private final Set<WorldPoint> bloodSpawnBloodTiles = new HashSet<WorldPoint>();
    private final Set<WorldPoint> maidenBloodTiles;
    private final Map<Integer, List<WorldPoint>> maidenBloodTilesToActivate;
    private final Map<Integer, List<WorldPoint>> activeMaidenBloodTiles;
    private final Set<WorldPoint> bloodSpawnBloodTilesToRemove = new HashSet<WorldPoint>();

    @Inject
    public MaidenMistakeDetector() {
        this.maidenBloodTiles = new HashSet<WorldPoint>();
        this.maidenBloodTilesToActivate = new HashMap<Integer, List<WorldPoint>>();
        this.activeMaidenBloodTiles = new HashMap<Integer, List<WorldPoint>>();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.bloodSpawnBloodTiles.clear();
        this.bloodSpawnBloodTilesToRemove.clear();
        this.maidenBloodTiles.clear();
        this.maidenBloodTilesToActivate.clear();
        this.activeMaidenBloodTiles.clear();
    }

    @Override
    protected void computeDetectingMistakes() {
        if (!this.detectingMistakes && this.isAlreadySpawned()) {
            this.detectingMistakes = true;
        }
    }

    @Override
    public List<TobMistake> detectMistakes(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        if (!raider.isDead() && this.isOnBloodTile(raider.getPreviousWorldLocation())) {
            return Collections.singletonList(TobMistake.MAIDEN_BLOOD);
        }
        return Collections.emptyList();
    }

    @Override
    public void afterDetect() {
        this.bloodSpawnBloodTiles.removeAll(this.bloodSpawnBloodTilesToRemove);
        this.bloodSpawnBloodTilesToRemove.clear();
    }

    private boolean isOnBloodTile(WorldPoint worldPoint) {
        return this.bloodSpawnBloodTiles.contains(worldPoint) || this.maidenBloodTiles.contains(worldPoint);
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved event) {
        if (event.getProjectile().getId() == 1578) {
            int gameTicksToActivate = (int)Math.floor((double)event.getProjectile().getRemainingCycles() / 30.0);
            int activationTick = this.client.getTickCount() + gameTicksToActivate;
            WorldPoint worldPoint = WorldPoint.fromLocal((Client)this.client, (LocalPoint)event.getPosition());
            this.maidenBloodTilesToActivate.computeIfAbsent(activationTick, k -> new ArrayList()).add(worldPoint);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject go = event.getGameObject();
        if (go.getId() == 32984) {
            this.bloodSpawnBloodTiles.add(go.getWorldLocation());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject go = event.getGameObject();
        if (go.getId() == 32984) {
            this.bloodSpawnBloodTilesToRemove.add(go.getWorldLocation());
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.detectingMistakes && "The Maiden of Sugadinti".equals(event.getActor().getName())) {
            this.detectingMistakes = true;
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        Actor actor = event.getActor();
        if (actor instanceof NPC && "The Maiden of Sugadinti".equals(event.getActor().getName())) {
            this.shutdown();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int currentGameTick = this.client.getTickCount();
        if (this.maidenBloodTilesToActivate.containsKey(currentGameTick)) {
            int deactivationTick = currentGameTick + 11;
            for (WorldPoint worldPoint : this.maidenBloodTilesToActivate.remove(currentGameTick)) {
                this.activeMaidenBloodTiles.computeIfAbsent(deactivationTick, k -> new ArrayList()).add(worldPoint);
                this.maidenBloodTiles.add(worldPoint);
            }
        }
        if (this.activeMaidenBloodTiles.containsKey(currentGameTick)) {
            for (WorldPoint worldPoint : this.activeMaidenBloodTiles.remove(currentGameTick)) {
                this.maidenBloodTiles.remove(worldPoint);
            }
        }
    }

    private boolean isAlreadySpawned() {
        return this.client.getNpcs().stream().anyMatch(npc -> "The Maiden of Sugadinti".equals(npc.getName()));
    }

    @VisibleForTesting
    public Set<WorldPoint> getBloodSpawnBloodTiles() {
        return Collections.unmodifiableSet(this.bloodSpawnBloodTiles);
    }

    @VisibleForTesting
    public Set<WorldPoint> getMaidenBloodTiles() {
        return Collections.unmodifiableSet(this.maidenBloodTiles);
    }
}

