/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobMistakeTrackerPlugin;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.BaseTobMistakeDetector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeathMistakeDetector
extends BaseTobMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(DeathMistakeDetector.class);
    private static final String REJOINED_PARTY_TEXT = "You have rejoined your party";
    private static final String NYLOCAS_NPC_NAME_PREFIX = "Nylocas";
    private final Set<String> playerDeaths = new HashSet<String>();
    private TobRoom currentRoom = null;
    @NonNull
    private String previousRoomText = "";

    @Inject
    public DeathMistakeDetector() {
    }

    @Override
    protected void computeDetectingMistakes() {
        this.detectingMistakes = true;
        if (this.currentRoom == null) {
            this.computeCurrentRoom();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.playerDeaths.clear();
        this.currentRoom = null;
    }

    @Override
    public List<TobMistake> detectMistakes(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        ArrayList<TobMistake> mistakes = new ArrayList<TobMistake>();
        if (this.playerDeaths.contains(raider.getName())) {
            mistakes.add(TobMistake.DEATH);
            if (this.currentRoom == null) {
                this.computeCurrentRoom();
            }
            if (this.currentRoom != null) {
                mistakes.add(this.currentRoom.getDeathMistake());
            }
        }
        return mistakes;
    }

    @Override
    public void afterDetect() {
        this.playerDeaths.clear();
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        Player player;
        Actor actor = event.getActor();
        if (actor instanceof Player && this.plugin.isLoadedRaider((player = (Player)actor).getName())) {
            this.playerDeaths.add(player.getName());
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (this.currentRoom == null) {
            this.computeCurrentRoomForBossNpc(event.getNpc());
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 2315) {
            return;
        }
        String roomText = TobMistakeTrackerPlugin.getTobRoomEnterText(this.client);
        if (this.currentRoom == null && REJOINED_PARTY_TEXT.equals(roomText)) {
            this.computeCurrentRoom();
        }
        if (this.previousRoomText.equals(roomText)) {
            return;
        }
        this.previousRoomText = roomText;
        TobRoom tobRoom = TobRoom.fromRoomName(roomText);
        if (tobRoom != null && tobRoom != this.currentRoom) {
            log.debug("New Tob Room: " + tobRoom);
            this.currentRoom = tobRoom;
        }
    }

    private void computeCurrentRoom() {
        if (this.currentRoom != null) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            this.computeCurrentRoomForBossNpc(npc);
            if (this.currentRoom == null) continue;
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            if (npc.getName() == null || !npc.getName().startsWith(NYLOCAS_NPC_NAME_PREFIX)) continue;
            this.currentRoom = TobRoom.NYLOCAS;
            log.debug("Computed Nylo Tob Room");
            return;
        }
    }

    private void computeCurrentRoomForBossNpc(NPC npc) {
        if (npc.getName() == null) {
            return;
        }
        TobRoom tobRoom = TobRoom.fromRoomBossName(npc.getName());
        if (tobRoom != null) {
            log.debug("Computed Tob Room: " + tobRoom);
            this.currentRoom = tobRoom;
        }
    }

    private static enum TobRoom {
        MAIDEN("The Maiden of Sugadinti", TobMistake.DEATH_MAIDEN, "The Maiden of Sugadinti"),
        BLOAT("The Pestilent Bloat", TobMistake.DEATH_BLOAT, "Pestilent Bloat"),
        NYLOCAS("The Nylocas", TobMistake.DEATH_NYLOCAS, "Nylocas Vasilias"),
        SOTETSEG("Sotetseg", TobMistake.DEATH_SOTETSEG, "Sotetseg"),
        XARPUS("Xarpus", TobMistake.DEATH_XARPUS, "Xarpus"),
        VERZIK("The Final Challenge", TobMistake.DEATH_VERZIK, "Verzik Vitur");

        private final String roomName;
        private final TobMistake deathMistake;
        private final String roomBossName;

        public static TobRoom fromRoomName(String roomName) {
            for (TobRoom tobRoom : TobRoom.values()) {
                if (!tobRoom.getRoomName().equals(roomName)) continue;
                return tobRoom;
            }
            return null;
        }

        public static TobRoom fromRoomBossName(String roomBossName) {
            for (TobRoom tobRoom : TobRoom.values()) {
                if (!tobRoom.getRoomBossName().equals(roomBossName)) continue;
                return tobRoom;
            }
            return null;
        }

        private TobRoom(String roomName, TobMistake deathMistake, String roomBossName) {
            this.roomName = roomName;
            this.deathMistake = deathMistake;
            this.roomBossName = roomBossName;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public TobMistake getDeathMistake() {
            return this.deathMistake;
        }

        public String getRoomBossName() {
            return this.roomBossName;
        }
    }
}

