/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.google.common.annotations.VisibleForTesting;
import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.BaseTobMistakeDetector;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BloatMistakeDetector
extends BaseTobMistakeDetector {
    private static final Logger log = LoggerFactory.getLogger(BloatMistakeDetector.class);
    private static final int BLOAT_HAND_BLOOD_GRAPHICS_OBJECT_ID = 1576;
    private final Set<WorldPoint> activeHandTiles = new HashSet<WorldPoint>();

    @Inject
    public BloatMistakeDetector() {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.activeHandTiles.clear();
    }

    @Override
    protected void computeDetectingMistakes() {
        if (!this.detectingMistakes && this.isAlreadySpawned()) {
            this.detectingMistakes = true;
        }
    }

    @Override
    public List<TobMistake> detectMistakes(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        if (!raider.isDead() && this.activeHandTiles.contains(raider.getPreviousWorldLocation())) {
            return Collections.singletonList(TobMistake.BLOAT_HAND);
        }
        return Collections.emptyList();
    }

    @Override
    public void afterDetect() {
        this.activeHandTiles.clear();
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        if (event.getGraphicsObject().getId() == 1576) {
            LocalPoint localPoint = event.getGraphicsObject().getLocation();
            this.activeHandTiles.add(WorldPoint.fromLocal((Client)this.client, (LocalPoint)localPoint));
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.detectingMistakes && "Pestilent Bloat".equals(event.getActor().getName())) {
            this.detectingMistakes = true;
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        Actor actor = event.getActor();
        if (actor instanceof NPC && "Pestilent Bloat".equals(event.getActor().getName())) {
            this.shutdown();
        }
    }

    private boolean isAlreadySpawned() {
        return this.client.getNpcs().stream().anyMatch(npc -> "Pestilent Bloat".equals(npc.getName()));
    }

    @VisibleForTesting
    public Set<WorldPoint> getActiveHandTiles() {
        return Collections.unmodifiableSet(this.activeHandTiles);
    }
}

