/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker.detector;

import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobMistakeTrackerPlugin;
import com.tobmistaketracker.TobRaider;
import java.util.List;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;

public abstract class BaseTobMistakeDetector {
    @Inject
    protected TobMistakeTrackerPlugin plugin;
    @Inject
    protected Client client;
    @Inject
    protected ClientThread clientThread;
    @Inject
    protected EventBus eventBus;
    public boolean detectingMistakes = false;

    protected BaseTobMistakeDetector() {
    }

    public void startup() {
        this.eventBus.register((Object)this);
        this.clientThread.invokeLater(this::computeDetectingMistakes);
    }

    public void shutdown() {
        this.detectingMistakes = false;
        this.eventBus.unregister((Object)this);
    }

    protected abstract void computeDetectingMistakes();

    public abstract List<TobMistake> detectMistakes(@NonNull TobRaider var1);

    public void afterDetect() {
    }

    public boolean isDetectingMistakes() {
        return this.detectingMistakes;
    }
}

