/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import com.tobmistaketracker.TobMistake;
import com.tobmistaketracker.TobMistakeTrackerConfig;
import com.tobmistaketracker.TobRaider;
import com.tobmistaketracker.detector.MistakeDetectorManager;
import com.tobmistaketracker.panel.TobMistakeTrackerPanel;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarClientStrChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@PluginDescriptor(name="Tob Mistake Tracker")
public class TobMistakeTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobMistakeTrackerPlugin.class);
    static final String CONFIG_GROUP = "tobMistakeTracker";
    public static final int TOB_ROOM_TRANSITION_SCRIPT_ID = 2315;
    private static final int TOB_BOSS_INTERFACE_ID = 1;
    private static final int TOB_BOSS_INTERFACE_TEXT_ID = 2;
    private static final int TOB_STATE_NO_PARTY = 0;
    private static final int TOB_STATE_IN_PARTY = 1;
    private static final int TOB_STATE_IN_TOB = 2;
    private static final int THEATRE_RAIDERS_VARC = 330;
    private static final int MAX_RAIDERS = 5;
    private static final int OVERHEAD_TEXT_TICK_TIMEOUT = 5;
    private static final int CYCLES_PER_GAME_TICK = 30;
    private static final int CYCLES_FOR_OVERHEAD_TEXT = 150;
    private static final Pattern STORY_MODE_FAILED_PATTERN = Pattern.compile("You have failed.");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TobMistakeTrackerConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private EventBus eventBus;
    @Inject
    private MistakeDetectorManager mistakeDetectorManager;
    private final BufferedImage icon = ImageUtil.loadImageResource(TobMistakeTrackerPlugin.class, (String)"panel_icon.png");
    private TobMistakeTrackerPanel panel;
    private NavigationButton navButton;
    private int raidState;
    @VisibleForTesting
    private boolean inTob;
    @VisibleForTesting
    private boolean allRaidersLoaded;
    @VisibleForTesting
    private boolean panelMightNeedReset;
    private String[] raiderNames;
    private Map<String, TobRaider> raiders;

    protected void startUp() throws Exception {
        this.panel = (TobMistakeTrackerPanel)((Object)this.injector.getInstance(TobMistakeTrackerPanel.class));
        this.panel.loadHeaderIcon(this.icon);
        this.navButton = NavigationButton.builder().tooltip("Tob Mistake Tracker").icon(this.icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.resetRaidState();
        this.clientThread.invokeLater(() -> {
            this.computeInTob();
            if (this.inTob) {
                this.tryLoadRaiders();
            }
        });
        this.panel.reload();
    }

    protected void shutDown() throws Exception {
        this.resetRaidState();
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel = null;
    }

    private void resetRaidState() {
        this.raidState = 0;
        this.inTob = false;
        this.allRaidersLoaded = false;
        this.panelMightNeedReset = true;
        this.raiderNames = new String[5];
        this.raiders = new HashMap<String, TobRaider>(5);
        this.mistakeDetectorManager.shutdown();
    }

    @Subscribe(priority=-1.0f)
    public void onGameTick(GameTick event) {
        if (!this.inTob) {
            return;
        }
        if (!this.allRaidersLoaded) {
            this.tryLoadRaiders();
        }
        this.detectAll();
        this.afterDetectAll();
    }

    private void detectAll() {
        for (TobRaider raider : this.raiders.values()) {
            if (raider == null) continue;
            this.detect(raider);
        }
    }

    private void detect(@NonNull TobRaider raider) {
        if (raider == null) {
            throw new NullPointerException("raider is marked @NonNull but is null");
        }
        List<TobMistake> mistakes = this.mistakeDetectorManager.detectMistakes(raider);
        if (!mistakes.isEmpty()) {
            log.debug(this.client.getTickCount() + " Found mistakes for " + raider.getName() + " - " + mistakes);
            for (TobMistake mistake : mistakes) {
                if (mistake == TobMistake.DEATH) {
                    raider.setDead(true);
                }
                this.addMistakeForPlayer(raider.getName(), mistake);
                this.addChatMessageForPlayerMistake(raider.getPlayer(), mistake);
            }
        }
        this.afterDetect(raider);
    }

    private void addChatMessageForPlayerMistake(Player player, TobMistake mistake) {
        String overheadText = mistake.getChatMessage();
        if (overheadText.isEmpty()) {
            return;
        }
        if (this.config.showMistakesOnOverheadText()) {
            player.setOverheadText(overheadText);
            player.setOverheadCycle(150);
        }
        if (this.config.showMistakesInChat()) {
            this.client.addChatMessage(ChatMessageType.PUBLICCHAT, player.getName(), mistake.getChatMessage(), null);
        }
    }

    private void afterDetect(TobRaider raider) {
        raider.setPreviousWorldLocationForOverlay(raider.getPreviousWorldLocation());
        raider.setPreviousWorldLocation(raider.getCurrentWorldLocation());
    }

    private void afterDetectAll() {
        this.mistakeDetectorManager.afterDetect();
    }

    private void tryLoadRaiders() {
        HashSet<String> raiderNamesSet = new HashSet<String>(this.getRaiderNames());
        if (raiderNamesSet.isEmpty()) {
            this.tryLoadRaiderNames();
            raiderNamesSet = new HashSet<String>(this.getRaiderNames());
        }
        for (Player player : this.client.getPlayers()) {
            if (player == null || player.getName() == null || this.raiders.containsKey(player.getName()) || !raiderNamesSet.contains(player.getName())) continue;
            this.raiders.put(player.getName(), new TobRaider(player));
        }
        int totalRaiders = raiderNamesSet.size();
        if (totalRaiders > 0 && this.raiders.size() == totalRaiders) {
            this.allRaidersLoaded = true;
        }
    }

    private void tryLoadRaiderNames() {
        for (int i = 0; i < 5; ++i) {
            String playerName = this.client.getVarcStrValue(330 + i);
            if (playerName == null || playerName.isEmpty()) continue;
            this.raiderNames[i] = Text.sanitize((String)playerName);
        }
    }

    private boolean shouldTrackMistakes() {
        return this.inTob;
    }

    private void addMistakeForPlayer(String playerName, TobMistake mistake) {
        if (this.shouldTrackMistakes()) {
            SwingUtilities.invokeLater(() -> this.panel.addMistakeForPlayer(playerName, mistake));
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        if (this.inTob && this.raiders.containsKey(event.getPlayer().getName())) {
            this.raiders.remove(event.getPlayer().getName());
            this.allRaidersLoaded = false;
        }
    }

    @Subscribe
    public void onVarClientStrChanged(VarClientStrChanged event) {
        if (event.getIndex() >= 330 && event.getIndex() < 335) {
            this.allRaidersLoaded = false;
            int raiderIndex = event.getIndex() - 330;
            String raiderName = this.client.getVarcStrValue(event.getIndex());
            this.raiderNames[raiderIndex] = raiderName != null && !raiderName.isEmpty() ? Text.sanitize((String)raiderName) : null;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.computeInTob();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        String roomText;
        if (this.inTob && this.panelMightNeedReset && event.getScriptId() == 2315 && "The Maiden of Sugadinti".equals(roomText = TobMistakeTrackerPlugin.getTobRoomEnterText(this.client))) {
            this.panel.newRaid(this.getRaiderNames());
            this.panelMightNeedReset = false;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            for (TobRaider raider : this.raiders.values()) {
                raider.setDead(false);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessageNode().getType() == ChatMessageType.GAMEMESSAGE && STORY_MODE_FAILED_PATTERN.matcher(event.getMessage()).find()) {
            for (TobRaider raider : this.raiders.values()) {
                raider.setDead(false);
            }
        }
    }

    private void computeInTob() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int newRaidState = this.client.getVarbitValue(6440);
        if (this.raidState != newRaidState) {
            if (newRaidState == 0 || newRaidState == 1) {
                this.resetRaidState();
            } else if (newRaidState == 2) {
                this.inTob = true;
                this.mistakeDetectorManager.startup();
            }
            this.raidState = newRaidState;
        }
    }

    public boolean isLoadedRaider(String playerName) {
        return playerName != null && this.raiders.containsKey(playerName);
    }

    public Iterable<TobRaider> getRaiders() {
        return Collections.unmodifiableCollection(this.raiders.values());
    }

    public List<String> getRaiderNames() {
        return Arrays.stream(this.raiderNames).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String getTobRoomEnterText(Client client) {
        Widget widget = client.getWidget(28, 1);
        if (widget != null && widget.getChild(2) != null) {
            Widget childWidget = widget.getChild(2);
            return childWidget.getText();
        }
        return "";
    }

    @Provides
    TobMistakeTrackerConfig provideConfig(ConfigManager configManager) {
        return (TobMistakeTrackerConfig)configManager.getConfig(TobMistakeTrackerConfig.class);
    }

    public boolean isInTob() {
        return this.inTob;
    }

    public boolean isAllRaidersLoaded() {
        return this.allRaidersLoaded;
    }

    public boolean isPanelMightNeedReset() {
        return this.panelMightNeedReset;
    }
}

