/*
 * Decompiled with CFR 0.152.
 */
package com.tobmistaketracker;

import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import lombok.NonNull;
import net.runelite.client.util.ImageUtil;

public enum TobMistake {
    DEATH("Death", "death.png", ""),
    DEATH_MAIDEN("Maiden Death", "death_maiden.png", "I'm planking!"),
    DEATH_BLOAT("Bloat Death", "death_bloat.png", "I'm planking!"),
    DEATH_NYLOCAS("Nylocas Death", "death_nylo.png", "I'm planking!"),
    DEATH_SOTETSEG("Sotetseg Death", "death_sot.png", "I'm planking!"),
    DEATH_XARPUS("Xarpus Death", "death_xarpus.png", "I'm planking!"),
    DEATH_VERZIK("Verzik Death", "death_verzik.png", "I'm planking!"),
    MAIDEN_BLOOD("Maiden Blood", "maiden_blood.png", "I'm drowning in Maiden's blood!"),
    BLOAT_HAND("Bloat Hand", "bloat_hand.png", "I'm stunned!"),
    VERZIK_P2_BOUNCE("Verzik P2 Bounce", "verzik_p2_bounce.png", "Bye!"),
    VERZIK_P2_BOMB("Verzik P2 Bomb", "verzik_p2_bomb.png", "I'm eating cabbages!"),
    VERZIK_P2_ACID("Verzik P2 Acid", "verzik_p2_acid.png", "I can't count to four!"),
    VERZIK_P3_MELEE("Verzik P3 Melee", "verzik_p3_melee.png", "I'm PKing my team!"),
    VERZIK_P3_WEB("Verzik P3 Web", "verzik_p3_web.png", "I was stuck in a web!"),
    VERZIK_P3_PURPLE("Verzik P3 Purple Tornado", "verzik_p3_purple.png", "I'm healing Verzik!");

    private static final Set<TobMistake> ROOM_DEATH_ENUMS;
    @NonNull
    private final String mistakeName;
    @NonNull
    private final String chatMessage;
    @NonNull
    private final BufferedImage mistakeImage;

    private TobMistake(@NonNull String mistakeName, String mistakeImagePath, String chatMessage) {
        if (mistakeName == null) {
            throw new NullPointerException("mistakeName is marked @NonNull but is null");
        }
        if (mistakeImagePath == null) {
            throw new NullPointerException("mistakeImagePath is marked @NonNull but is null");
        }
        if (chatMessage == null) {
            throw new NullPointerException("chatMessage is marked @NonNull but is null");
        }
        this.mistakeName = mistakeName;
        this.chatMessage = chatMessage;
        this.mistakeImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)mistakeImagePath);
    }

    public static boolean isRoomDeath(TobMistake mistake) {
        return ROOM_DEATH_ENUMS.contains((Object)mistake);
    }

    @NonNull
    public String getMistakeName() {
        return this.mistakeName;
    }

    @NonNull
    public String getChatMessage() {
        return this.chatMessage;
    }

    @NonNull
    public BufferedImage getMistakeImage() {
        return this.mistakeImage;
    }

    static {
        ROOM_DEATH_ENUMS = EnumSet.of(DEATH_MAIDEN, new TobMistake[]{DEATH_BLOAT, DEATH_NYLOCAS, DEATH_SOTETSEG, DEATH_XARPUS, DEATH_VERZIK});
    }
}

