/*
 * Decompiled with CFR 0.152.
 */
package com.entrana;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;

public class ProhibitedItems {
    private static final Set<Integer> allowedIds = ImmutableSet.of((Object)25818, (Object)88, (Object)89, (Object)10069, (Object)10073, (Object)10071, (Object[])new Integer[]{10074, 26551, 7409, 3844, 26488, 12612, 26490, 12610, 26492, 12608, 26494, 3840, 26496, 3842, 26498, 579, 7396, 7394, 577, 7392, 7390, 1017, 12455, 12453, 581, 12451, 12449, 1033, 1035, 4300, 4298, 4302, 4310, 4308, 4304, 2894, 2896, 2898, 2900, 2902, 2904, 2906, 2908, 2910, 2912, 2914, 2916, 2918, 2920, 2922, 2924, 2926, 2928, 2930, 2932, 2934, 2936, 2938, 2940, 2942, 1019, 1021, 1023, 1027, 1029, 1031, 3759, 3761, 3763, 3765, 3767, 3769, 3771, 3773, 3775, 3777, 3779, 3781, 3783, 3785, 3787, 3789, 3791, 3793, 3795, 3797, 3799, 3107, 1061, 1059, 3105, 23413, 1063, 10448, 10450, 10446, 12261, 12197, 12273, 4315, 4317, 4319, 4321, 4323, 4325, 4327, 4329, 4331, 4333, 4335, 4337, 4339, 4341, 4343, 4345, 4347, 4349, 4351, 4353, 4355, 4357, 4359, 4361, 4363, 4365, 4367, 4369, 4371, 4373, 4375, 4377, 4379, 4381, 4383, 4385, 4387, 4389, 4391, 4393, 4395, 4397, 4399, 4401, 4403, 4405, 4407, 4409, 4411, 4413, 20217, 20214, 20211, 6106, 6110, 1580, 10075, 626, 628, 630, 632, 634, 636, 638, 640, 642, 644, 646, 648, 650, 652, 654, 656, 658, 660, 662, 664, 6145, 23037, 2579, 9006});
    private static final Set<Integer> prohibitedIds = ImmutableSet.of((Object)8966, (Object)8967, (Object)8968, (Object)8969, (Object)8970, (Object)8971, (Object[])new Integer[]{8650, 8652, 8654, 8656, 8658, 8660, 8662, 8664, 8666, 8668, 8670, 8672, 8674, 8676, 8678, 8680, 20251, 13328, 20254, 20257, 20260, 25822, 26424, 20263, 25056, 11891, 11892, 11259, 26370, 11814, 11812, 11816, 11810, 11798, 11818, 11820, 11822, 23360, 24219, 25644, 6, 8, 10, 12, 26520, 26522, 26524, 26526, 11238, 11240, 11242, 11244, 11246, 11248, 11250, 11252, 11254, 11256, 19732, 23768, 20703, 25342, 10010, 12016, 12013, 12014, 12015, 25555, 25549, 25551, 25553});
    private static final Map<Integer, Boolean> cachedIds = new HashMap<Integer, Boolean>();
    private final ItemManager itemManager;

    public ProhibitedItems(ItemManager itemManager) {
        this.itemManager = itemManager;
    }

    boolean isProhibited(int id) {
        if (allowedIds.contains(id)) {
            return false;
        }
        if (prohibitedIds.contains(id)) {
            return true;
        }
        if (cachedIds.containsKey(id)) {
            return cachedIds.get(id);
        }
        boolean prohibited = false;
        if (this.isCombatGear(id)) {
            prohibited = true;
        }
        cachedIds.put(id, prohibited);
        return prohibited;
    }

    private boolean isCombatGear(int id) {
        ItemStats itemStats = this.itemManager.getItemStats(id, false);
        if (itemStats == null || !itemStats.isEquipable()) {
            return false;
        }
        ItemEquipmentStats stats = itemStats.getEquipment();
        int slot = itemStats.getEquipment().getSlot();
        if (slot == EquipmentInventorySlot.AMMO.getSlotIdx()) {
            return false;
        }
        if (slot == EquipmentInventorySlot.AMULET.getSlotIdx()) {
            return false;
        }
        if (slot == EquipmentInventorySlot.RING.getSlotIdx()) {
            return false;
        }
        ItemComposition itemComposition = this.itemManager.getItemComposition(id);
        String name = itemComposition.getName().toLowerCase();
        if (name.contains("bracelet")) {
            return false;
        }
        if (stats.getAcrush() > 0) {
            return true;
        }
        if (stats.getAstab() > 0) {
            return true;
        }
        if (stats.getAslash() > 0) {
            return true;
        }
        if (stats.getAmagic() > 0) {
            return true;
        }
        if (stats.getArange() > 0) {
            return true;
        }
        if (stats.getDmagic() > 0) {
            return true;
        }
        if (stats.getDrange() > 0) {
            return true;
        }
        if (stats.getDslash() > 0) {
            return true;
        }
        if (stats.getDstab() > 0) {
            return true;
        }
        return stats.getStr() > 0;
    }
}

