/*
 * Decompiled with CFR 0.152.
 */
package com.entrana;

import com.entrana.ContainerHighlight;
import com.entrana.EntranaConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Entrana")
public class EntranaPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EntranaPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EntranaConfig config;
    @Inject
    private ContainerHighlight containerHighlight;
    @Inject
    private OverlayManager overlayManager;
    private static final WorldArea entranaDock = new WorldArea(new WorldPoint(3043, 3234, 0), 8, 4);

    @Provides
    EntranaConfig provideConfig(ConfigManager configManager) {
        return (EntranaConfig)configManager.getConfig(EntranaConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        if (!entranaDock.contains2D(player.getWorldLocation())) {
            this.overlayManager.remove((Overlay)this.containerHighlight);
            return;
        }
        this.overlayManager.add((Overlay)this.containerHighlight);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.containerHighlight);
    }
}

