/*
 * Decompiled with CFR 0.152.
 */
package com.entrana;

import com.entrana.EntranaConfig;
import com.entrana.EntranaPlugin;
import com.entrana.ProhibitedItems;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

@Singleton
public class ContainerHighlight
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final EntranaPlugin plugin;
    private final EntranaConfig config;
    private final ProhibitedItems prohibitedItems;

    @Inject
    private ContainerHighlight(ItemManager itemManager, EntranaPlugin plugin, EntranaConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.prohibitedItems = new ProhibitedItems(itemManager);
        this.showOnInventory();
        this.showOnEquipment();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        int groupId = WidgetInfo.TO_GROUP((int)itemWidget.getWidget().getId());
        if (!this.prohibitedItems.isProhibited(itemId) || groupId != 387 && groupId != 149 && groupId != 192) {
            System.out.println(WidgetInfo.TO_GROUP((int)itemWidget.getWidget().getId()));
            return;
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), this.config.color());
        graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
    }

    private BufferedImage overlay(BufferedImage image, Color color) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage overlayed = new BufferedImage(w, h, 2);
        Graphics2D g = overlayed.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return overlayed;
    }
}

