/*
 * Decompiled with CFR 0.152.
 */
package com.groupironpanel;

import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.Experience;
import net.runelite.client.RuneLite;
import net.runelite.client.hiscore.HiscoreClient;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.hiscore.Skill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerStatsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(PlayerStatsPanel.class);
    private static final List<HiscoreSkill> SKILLS = ImmutableList.of((Object)HiscoreSkill.ATTACK, (Object)HiscoreSkill.HITPOINTS, (Object)HiscoreSkill.MINING, (Object)HiscoreSkill.STRENGTH, (Object)HiscoreSkill.AGILITY, (Object)HiscoreSkill.SMITHING, (Object)HiscoreSkill.DEFENCE, (Object)HiscoreSkill.HERBLORE, (Object)HiscoreSkill.FISHING, (Object)HiscoreSkill.RANGED, (Object)HiscoreSkill.THIEVING, (Object)HiscoreSkill.COOKING, (Object[])new HiscoreSkill[]{HiscoreSkill.PRAYER, HiscoreSkill.CRAFTING, HiscoreSkill.FIREMAKING, HiscoreSkill.MAGIC, HiscoreSkill.FLETCHING, HiscoreSkill.WOODCUTTING, HiscoreSkill.RUNECRAFT, HiscoreSkill.SLAYER, HiscoreSkill.FARMING, HiscoreSkill.CONSTRUCTION, HiscoreSkill.HUNTER});
    private Map<HiscoreSkill, JLabel> skillToLabel = new HashMap<HiscoreSkill, JLabel>();
    private HiscoreClient hiscoreClient;
    private String username;
    private JLabel usernameLabel;

    public PlayerStatsPanel(HiscoreClient hiscoreClient) {
        this.hiscoreClient = hiscoreClient;
        this.buildPanel();
    }

    public void clearStats() {
        for (Map.Entry<HiscoreSkill, JLabel> entry : this.skillToLabel.entrySet()) {
            JLabel label = entry.getValue();
            if (label == null) continue;
            label.setText("-");
        }
    }

    public void updateStats(HiscoreResult playerResult) {
        if (playerResult == null) {
            return;
        }
        for (Map.Entry<HiscoreSkill, JLabel> entry : this.skillToLabel.entrySet()) {
            HiscoreSkill skill = entry.getKey();
            JLabel label = entry.getValue();
            if (label == null) continue;
            if (skill == null) {
                int combatLevel = Experience.getCombatLevel((int)playerResult.getSkill(HiscoreSkill.ATTACK).getLevel(), (int)playerResult.getSkill(HiscoreSkill.STRENGTH).getLevel(), (int)playerResult.getSkill(HiscoreSkill.DEFENCE).getLevel(), (int)playerResult.getSkill(HiscoreSkill.HITPOINTS).getLevel(), (int)playerResult.getSkill(HiscoreSkill.MAGIC).getLevel(), (int)playerResult.getSkill(HiscoreSkill.RANGED).getLevel(), (int)playerResult.getSkill(HiscoreSkill.PRAYER).getLevel());
                label.setText(Integer.toString(combatLevel));
            } else {
                Skill resultSkill = playerResult.getSkill(skill);
                if (resultSkill != null) {
                    long experience = resultSkill.getExperience();
                    if (experience > -1L && skill.getType() == HiscoreSkillType.SKILL) {
                        label.setText(String.valueOf(Experience.getLevelForXp((int)((int)experience))));
                    } else {
                        label.setText(String.valueOf(resultSkill.getLevel()));
                    }
                }
            }
            label.setToolTipText(this.buildSkillPanelTooltip(playerResult, skill));
        }
    }

    public String getPlayer() {
        return this.username;
    }

    public void setPlayer(String username) {
        this.username = username;
        this.usernameLabel.setText(this.username);
        if (username == null || username.isEmpty()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    private void buildPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.setLayout(new GridBagLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel usernamePanel = new JPanel();
        usernamePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.usernameLabel = new JLabel();
        usernamePanel.add(this.usernameLabel);
        this.add((Component)usernamePanel, constraints);
        ++constraints.gridy;
        JPanel statsPanel = new JPanel();
        statsPanel.setLayout(new GridLayout(8, 3));
        statsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        for (HiscoreSkill skill : SKILLS) {
            statsPanel.add(this.buildSkillPanel(skill));
        }
        this.add((Component)statsPanel, constraints);
        ++constraints.gridy;
        JPanel summaryStatsPanel = new JPanel();
        summaryStatsPanel.setLayout(new GridLayout(1, 2));
        summaryStatsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        summaryStatsPanel.add(this.buildSkillPanel(null));
        summaryStatsPanel.add(this.buildSkillPanel(HiscoreSkill.OVERALL));
        this.add((Component)summaryStatsPanel, constraints);
        ++constraints.gridy;
        this.setVisible(false);
    }

    private JPanel buildSkillPanel(HiscoreSkill skill) {
        JPanel panel = new JPanel();
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        String skillName = skill == null ? "combat" : skill.name().toLowerCase();
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(ImageUtil.loadImageResource(RuneLite.class, (String)("/skill_icons_small/" + skillName + ".png"))));
        label.setText("-");
        label.setIconTextGap(skill == HiscoreSkill.OVERALL || skill == null ? 10 : 4);
        label.setToolTipText(skill == null ? "Combat" : skill.getName());
        this.skillToLabel.put(skill, label);
        panel.add(label);
        return panel;
    }

    private String buildSkillPanelTooltip(HiscoreResult playerResult, HiscoreSkill skill) {
        long experience;
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body style = 'padding: 5px;color:#989898'>");
        if (skill == null) {
            double combatLevel = Experience.getCombatLevelPrecise((int)playerResult.getSkill(HiscoreSkill.ATTACK).getLevel(), (int)playerResult.getSkill(HiscoreSkill.STRENGTH).getLevel(), (int)playerResult.getSkill(HiscoreSkill.DEFENCE).getLevel(), (int)playerResult.getSkill(HiscoreSkill.HITPOINTS).getLevel(), (int)playerResult.getSkill(HiscoreSkill.MAGIC).getLevel(), (int)playerResult.getSkill(HiscoreSkill.RANGED).getLevel(), (int)playerResult.getSkill(HiscoreSkill.PRAYER).getLevel());
            double combatExperience = playerResult.getSkill(HiscoreSkill.ATTACK).getExperience() + playerResult.getSkill(HiscoreSkill.STRENGTH).getExperience() + playerResult.getSkill(HiscoreSkill.DEFENCE).getExperience() + playerResult.getSkill(HiscoreSkill.HITPOINTS).getExperience() + playerResult.getSkill(HiscoreSkill.MAGIC).getExperience() + playerResult.getSkill(HiscoreSkill.RANGED).getExperience() + playerResult.getSkill(HiscoreSkill.PRAYER).getExperience();
            builder.append("<p><span style = 'color:white'>Combat</span></p>");
            builder.append("<p><span style = 'color:white'>Exact Combat Level:</span> " + QuantityFormatter.formatNumber((double)combatLevel) + "</p>");
            builder.append("<p><span style = 'color:white'>Experience:</span> " + QuantityFormatter.formatNumber((double)combatExperience) + "</p>");
        } else if (skill == HiscoreSkill.OVERALL) {
            Skill overallSkill = playerResult.getSkill(skill);
            String rank = overallSkill.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)overallSkill.getRank());
            String exp = overallSkill.getExperience() == -1L ? "Unranked" : QuantityFormatter.formatNumber((long)overallSkill.getExperience());
            builder.append("<p><span style = 'color:white'>" + skill.getName() + "</span></p>");
            builder.append("<p><span style = 'color:white'>Rank:</span> " + rank + "</p>");
            builder.append("<p><span style = 'color:white'>Experience:</span> " + exp + "</p>");
        } else {
            int currentLevel;
            String exp;
            Skill requestedSkill = playerResult.getSkill(skill);
            long experience2 = requestedSkill.getExperience();
            String rank = requestedSkill.getRank() == -1 ? "Unranked" : QuantityFormatter.formatNumber((long)requestedSkill.getRank());
            String string = exp = experience2 == -1L ? "Unranked" : QuantityFormatter.formatNumber((long)experience2);
            String remainingXp = experience2 == -1L ? "Unranked" : ((currentLevel = Experience.getLevelForXp((int)((int)experience2))) + 1 <= 126 ? QuantityFormatter.formatNumber((long)((long)Experience.getXpForLevel((int)(currentLevel + 1)) - experience2)) : "0");
            builder.append("<p><span style = 'color:white'>Skill:</span> " + skill.getName() + "</p>");
            builder.append("<p><span style = 'color:white'>Rank:</span> " + rank + "</p>");
            builder.append("<p><span style = 'color:white'>Experience:</span> " + exp + "</p>");
            builder.append("<p><span style = 'color:white'>Remaining XP:</span> " + remainingXp + "</p>");
        }
        if (skill != null && skill.getType() == HiscoreSkillType.SKILL && (experience = playerResult.getSkill(skill).getExperience()) >= 0L) {
            int currentXp = (int)experience;
            int currentLevel = Experience.getLevelForXp((int)currentXp);
            int xpForCurrentLevel = Experience.getXpForLevel((int)currentLevel);
            int xpForNextLevel = currentLevel + 1 <= 126 ? Experience.getXpForLevel((int)(currentLevel + 1)) : -1;
            double xpGained = currentXp - xpForCurrentLevel;
            double xpGoal = xpForNextLevel != -1 ? (double)(xpForNextLevel - xpForCurrentLevel) : 100.0;
            int progress = (int)(xpGained / xpGoal * 100.0);
            builder.append("<div style = 'margin-top:3px'>");
            builder.append("<div style = 'background: #070707; border: 1px solid #070707; height: 6px; width: 100%;'>");
            builder.append("<div style = 'height: 6px; width: " + progress + "%; background: #dc8a00;'>");
            builder.append("</div>");
            builder.append("</div>");
            builder.append("</div>");
        }
        builder.append("</body></html>");
        return builder.toString();
    }
}

