/*
 * Decompiled with CFR 0.152.
 */
package com.groupironpanel;

import com.google.inject.Provides;
import com.groupironpanel.GroupIronPanel;
import com.groupironpanel.GroupIronPanelConfig;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.hiscore.HiscoreClient;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Group Iron Panel", description="A panel that displays your Group Ironman group's skills and hiscores all in one place")
public class GroupIronPanelPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GroupIronPanelPlugin.class);
    private static final Pattern GIM_USERNAME_PATTERN = Pattern.compile("^<.*>(.*)<.*>$");
    private int autoDetectTickCooldown = 0;
    private GroupIronPanel panel;
    private NavigationButton toolbarButton;
    @Inject
    private Client client;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private GroupIronPanelConfig config;
    @Inject
    private HiscoreClient hiscoreClient;

    @Provides
    GroupIronPanelConfig provideConfig(ConfigManager configManager) {
        return (GroupIronPanelConfig)configManager.getConfig(GroupIronPanelConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("groupironpanel")) {
            this.executor.execute(this::updatePanel);
        }
    }

    protected void startUp() throws Exception {
        this.panel = new GroupIronPanel(this.hiscoreClient);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/GroupIron.png");
        this.toolbarButton = NavigationButton.builder().tooltip("Group Iron").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.toolbarButton);
        this.updatePanel();
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.toolbarButton);
    }

    @Subscribe
    private void onGameTick(GameTick gameTick) throws IOException {
        if (this.config.autoDetectGroup()) {
            if (this.autoDetectTickCooldown == 0) {
                this.tryAutoDetectGroupInformation();
                this.autoDetectTickCooldown = 5;
            } else if (this.autoDetectTickCooldown > 0) {
                --this.autoDetectTickCooldown;
            }
        }
    }

    private void tryAutoDetectGroupInformation() {
        Widget groupMembersContainerWidget;
        Widget groupNameContainerWidget = this.client.getWidget(726, 1);
        if (groupNameContainerWidget == null) {
            return;
        }
        Widget[] groupNameWidgets = groupNameContainerWidget.getChildren();
        String groupName = null;
        if (groupNameWidgets != null) {
            for (Widget child : groupNameWidgets) {
                String widgetText = child.getText();
                if (widgetText == null || widgetText.length() <= 0) continue;
                groupName = widgetText;
            }
        }
        if ((groupMembersContainerWidget = this.client.getWidget(726, 6)) == null) {
            return;
        }
        Widget[] groupMemberWidgets = groupMembersContainerWidget.getChildren();
        ArrayList<String> groupMembers = new ArrayList<String>();
        if (groupMemberWidgets != null) {
            for (Widget child : groupMemberWidgets) {
                String widgetName = child.getName();
                Matcher matcher = GIM_USERNAME_PATTERN.matcher(widgetName);
                if (!matcher.find()) continue;
                groupMembers.add(matcher.group(1));
            }
        }
        if (groupName != null && !groupName.isEmpty() && groupMembers.size() > 0) {
            this.config.setGroupName(groupName);
            this.config.setGroupMembers(Text.toCSV(groupMembers));
        }
    }

    private void updatePanel() {
        this.panel.setGroupName(this.config.groupName());
        this.panel.setGroupMembers(Text.fromCSV((String)this.config.groupMembers()));
        this.panel.refreshPanel();
    }
}

