/*
 * Decompiled with CFR 0.152.
 */
package com.groupironpanel;

import com.groupironpanel.PlayerStatsPanel;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.hiscore.HiscoreClient;
import net.runelite.client.hiscore.HiscoreEndpoint;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupIronPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(GroupIronPanel.class);
    private static final int GROUP_IRON_MAX_GROUP_SIZE = 5;
    private HiscoreClient hiscoreClient;
    private JLabel groupNameLabel;
    private List<PlayerStatsPanel> playerStatsPanels;

    public GroupIronPanel(HiscoreClient hiscoreClient) {
        this.hiscoreClient = hiscoreClient;
        this.rebuild();
    }

    private void rebuild() {
        this.removeAll();
        JPanel groupNamePanel = new JPanel();
        groupNamePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        groupNamePanel.setBorder(new EmptyBorder(8, 0, 8, 0));
        this.groupNameLabel = new JLabel();
        this.groupNameLabel.setFont(new Font(this.groupNameLabel.getFont().getName(), 1, 18));
        groupNamePanel.add(this.groupNameLabel);
        BufferedImage refreshIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/Refresh.png");
        JLabel refreshButton = new JLabel();
        refreshButton.setIcon(new ImageIcon(refreshIcon));
        refreshButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                GroupIronPanel.this.refreshPanel();
            }
        });
        groupNamePanel.add(refreshButton);
        this.add(groupNamePanel);
        this.playerStatsPanels = new ArrayList<PlayerStatsPanel>();
        for (int i = 0; i < 5; ++i) {
            PlayerStatsPanel statsPanel = new PlayerStatsPanel(this.hiscoreClient);
            statsPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
            this.playerStatsPanels.add(statsPanel);
            this.add(statsPanel);
        }
    }

    public void setGroupName(String groupName) {
        this.groupNameLabel.setText(groupName);
    }

    public void setGroupMembers(List<String> groupMembers) {
        int i;
        for (i = 0; i < groupMembers.size(); ++i) {
            this.playerStatsPanels.get(i).setPlayer(groupMembers.get(i));
        }
        while (i < 5) {
            this.playerStatsPanels.get(i).setPlayer(null);
            ++i;
        }
    }

    public void refreshPanel() {
        for (PlayerStatsPanel panel2 : this.playerStatsPanels) {
            panel2.clearStats();
        }
        List<CompletableFuture> hiscoreFutures = this.playerStatsPanels.stream().map(panel -> this.hiscoreClient.lookupAsync(panel.getPlayer(), HiscoreEndpoint.NORMAL)).collect(Collectors.toList());
        CompletableFuture.allOf(hiscoreFutures.toArray(new CompletableFuture[0])).whenCompleteAsync((result, ex) -> {
            List results = hiscoreFutures.stream().map(future -> {
                try {
                    return (HiscoreResult)future.get();
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    return null;
                }
            }).collect(Collectors.toList());
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < this.playerStatsPanels.size(); ++i) {
                    HiscoreResult hiscoreResult = (HiscoreResult)results.get(i);
                    if (hiscoreResult == null) continue;
                    this.playerStatsPanels.get(i).updateStats(hiscoreResult);
                }
            });
        });
    }
}

