/*
 * Decompiled with CFR 0.152.
 */
package hsj.external.theatreofbloodstats;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import hsj.external.theatreofbloodstats.TheatreOfBloodStatsConfig;
import hsj.external.theatreofbloodstats.TheatreOfBloodStatsInfoBox;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Theatre of Blood Stats", description="Theatre of Blood room splits and damage", tags={"combat", "raid", "pve", "pvm", "bosses", "tob"}, enabledByDefault=false)
public class TheatreOfBloodStatsPlugin
extends Plugin {
    private static final DecimalFormat DMG_FORMAT = new DecimalFormat("#,##0");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.0");
    private static final int PRECISE_TIMER = 11866;
    private static final int THEATRE_OF_BLOOD_ROOM_STATUS = 6447;
    private static final int TOB_LOBBY = 14642;
    private static final int NYLOCAS_REGION = 13122;
    private static final int SOTETSEG_MAZE_REGION = 13379;
    private static final int NYLOCAS_WAVES_TOTAL = 31;
    private static final int TICK_LENGTH = 600;
    private static final int MAIDEN_ID = 25748;
    private static final int BLOAT_ID = 25749;
    private static final int NYLOCAS_ID = 25750;
    private static final int SOTETSEG_ID = 25751;
    private static final int XARPUS_ID = 25752;
    private static final int VERZIK_ID = 22473;
    private static final Pattern MAIDEN_WAVE = Pattern.compile("Wave 'The Maiden of Sugadinti' \\(.*\\) complete!");
    private static final Pattern BLOAT_WAVE = Pattern.compile("Wave 'The Pestilent Bloat' \\(.*\\) complete!Duration: (\\d+):(\\d+)\\.?(\\d+)");
    private static final Pattern NYLOCAS_WAVE = Pattern.compile("Wave 'The Nylocas' \\(.*\\) complete!");
    private static final Pattern SOTETSEG_WAVE = Pattern.compile("Wave 'Sotetseg' \\(.*\\) complete!");
    private static final Pattern XARPUS_WAVE = Pattern.compile("Wave 'Xarpus' \\(.*\\) complete!");
    private static final Pattern COMPLETION = Pattern.compile("Theatre of Blood total completion time:");
    private static final Set<Integer> NYLOCAS_IDS = ImmutableSet.of((Object)8344, (Object)8347, (Object)8350, (Object)8353, (Object)10776, (Object)10779, (Object[])new Integer[]{10782, 10785, 10793, 10796, 10799, 10802, 8343, 8346, 8349, 8352, 10775, 10778, 10781, 10784, 10792, 10795, 10798, 10801, 8342, 8345, 8348, 8351, 10774, 10777, 10780, 10783, 10791, 10794, 10797, 10800});
    private static final Set<Point> NYLOCAS_VALID_SPAWNS = ImmutableSet.of((Object)new Point(17, 24), (Object)new Point(17, 25), (Object)new Point(18, 24), (Object)new Point(18, 25), (Object)new Point(31, 9), (Object)new Point(31, 10), (Object[])new Point[]{new Point(32, 9), new Point(32, 10), new Point(46, 24), new Point(46, 25), new Point(47, 24), new Point(47, 25)});
    private static final Set<String> BOSS_NAMES = ImmutableSet.of((Object)"The Maiden of Sugadinti", (Object)"Pestilent Bloat", (Object)"Nylocas Vasilias", (Object)"Sotetseg", (Object)"Xarpus", (Object)"Verzik Vitur", (Object[])new String[0]);
    @Inject
    private Client client;
    @Inject
    private TheatreOfBloodStatsConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    private TheatreOfBloodStatsInfoBox maidenInfoBox;
    private TheatreOfBloodStatsInfoBox bloatInfoBox;
    private TheatreOfBloodStatsInfoBox nyloInfoBox;
    private TheatreOfBloodStatsInfoBox soteInfoBox;
    private TheatreOfBloodStatsInfoBox xarpusInfoBox;
    private TheatreOfBloodStatsInfoBox verzikInfoBox;
    private int prevRegion;
    private boolean tobInside;
    private boolean instanced;
    private boolean preciseTimers;
    private int maidenStartTick = -1;
    private int maiden70time;
    private int maiden50time;
    private int maiden30time;
    private int nyloStartTick = -1;
    private int currentNylos;
    private boolean nyloWavesFinished;
    private boolean nyloCleanupFinished;
    private boolean waveThisTick = false;
    private int waveTime;
    private int cleanupTime;
    private int bossSpawnTime;
    private int nyloWave = 0;
    private int soteStartTick = -1;
    private boolean sote66;
    private int sote66time;
    private boolean sote33;
    private int sote33time;
    private int xarpusStartTick = -1;
    private int xarpusAcidTime;
    private int xarpusRecoveryTime;
    private int xarpusPreScreech;
    private int xarpusPreScreechTotal;
    private int verzikStartTick = -1;
    private int verzikP1time;
    private int verzikP2time;
    private double verzikP1personal;
    private double verzikP1total;
    private double verzikP2personal;
    private double verzikP2total;
    private double verzikP2healed;
    private final Map<String, Integer> personalDamage = new HashMap<String, Integer>();
    private final Map<String, Integer> totalDamage = new HashMap<String, Integer>();
    private final Map<String, Integer> totalHealing = new HashMap<String, Integer>();

    @Provides
    TheatreOfBloodStatsConfig provideConfig(ConfigManager configManager) {
        return (TheatreOfBloodStatsConfig)configManager.getConfig(TheatreOfBloodStatsConfig.class);
    }

    protected void shutDown() throws Exception {
        this.resetAll();
        this.resetAllInfoBoxes();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        int tobVar = this.client.getVarbitValue(6440);
        this.tobInside = tobVar == 2 || tobVar == 3;
        int preciseTimerVar = this.client.getVarbitValue(11866);
        boolean bl = this.preciseTimers = preciseTimerVar == 1;
        if (!this.tobInside) {
            this.resetAll();
        }
        int region = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        int status = this.client.getVarbitValue(6447);
        if (status == 1 && region != this.prevRegion && region != 13379) {
            this.prevRegion = region;
        }
        if (region == 14642) {
            this.resetMaiden();
            this.resetBloat();
            this.resetNylo();
            this.resetSote();
            this.resetXarpus();
            this.resetVerzik();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Object roomTime;
        Object damage;
        String roomTime2;
        String healing;
        double total;
        double personal;
        if (!this.tobInside || event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String strippedMessage = Text.removeTags((String)event.getMessage());
        ArrayList messages = new ArrayList(Collections.emptyList());
        if (MAIDEN_WAVE.matcher(strippedMessage).find()) {
            personal = this.personalDamage.getOrDefault("The Maiden of Sugadinti", 0).intValue();
            total = this.totalDamage.getOrDefault("The Maiden of Sugadinti", 0).intValue();
            int healed = this.totalHealing.getOrDefault("The Maiden of Sugadinti", 0);
            healing = "Total Healing - " + DMG_FORMAT.format(healed);
            double percent = personal / total * 100.0;
            roomTime2 = "";
            Object splits = "";
            damage = "";
            messages.clear();
            if (this.maidenStartTick > 0) {
                int roomTicks = this.client.getTickCount() - this.maidenStartTick;
                roomTime2 = this.formatTime(roomTicks);
                splits = "70% - " + this.formatTime(this.maiden70time) + "</br>50% - " + this.formatTime(this.maiden50time) + " (" + this.formatTime(this.maiden50time - this.maiden70time) + ")</br>30% - " + this.formatTime(this.maiden30time) + " (" + this.formatTime(this.maiden30time - this.maiden50time) + ")</br>Room Complete - " + roomTime2 + " (" + this.formatTime(roomTicks - this.maiden30time) + ")";
                if (this.config.chatboxSplits()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("70% - ").append(Color.RED, this.formatTime(this.maiden70time)).build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("50% - ").append(Color.RED, this.formatTime(this.maiden50time) + " (" + this.formatTime(this.maiden50time - this.maiden70time) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("30% - ").append(Color.RED, this.formatTime(this.maiden30time) + " (" + this.formatTime(this.maiden30time - this.maiden50time) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Room Complete - ").append(Color.RED, roomTime2 + " (" + this.formatTime(roomTicks - this.maiden30time) + ")").build());
                }
            }
            if (personal > 0.0) {
                damage = "Personal Boss Damage - " + DMG_FORMAT.format(personal);
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Personal Boss Damage - ").append(Color.RED, DMG_FORMAT.format(personal) + " (" + DECIMAL_FORMAT.format(percent) + "%)").build());
                }
            }
            if (this.config.chatboxHealed()) {
                messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total Healing - ").append(Color.RED, DMG_FORMAT.format(healed)).build());
            }
            this.maidenInfoBox = this.createInfoBox(25748, "Maiden", roomTime2, DECIMAL_FORMAT.format(percent), (String)damage, (String)splits, healing);
            this.infoBoxManager.addInfoBox((InfoBox)this.maidenInfoBox);
            this.resetMaiden();
        } else if (BLOAT_WAVE.matcher(strippedMessage).find()) {
            personal = this.personalDamage.getOrDefault("Pestilent Bloat", 0).intValue();
            total = this.totalDamage.getOrDefault("Pestilent Bloat", 0).intValue();
            double percent = personal / total * 100.0;
            Matcher m = BLOAT_WAVE.matcher(strippedMessage);
            roomTime = "";
            if (m.find()) {
                roomTime = this.preciseTimers ? m.group(1) + ":" + m.group(2) + "." + m.group(3).charAt(0) : m.group(1) + ":" + m.group(2);
            }
            Object damage2 = "";
            messages.clear();
            if (personal > 0.0) {
                damage2 = "Personal Boss Damage - " + DMG_FORMAT.format(personal);
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Personal Boss Damage - ").append(Color.RED, DMG_FORMAT.format(personal) + " (" + DECIMAL_FORMAT.format(percent) + "%)").build());
                }
            }
            this.bloatInfoBox = this.createInfoBox(25749, "Bloat", (String)roomTime, DECIMAL_FORMAT.format(percent), (String)damage2, "Room Complete - " + (String)roomTime, "");
            this.infoBoxManager.addInfoBox((InfoBox)this.bloatInfoBox);
            this.resetBloat();
        } else if (NYLOCAS_WAVE.matcher(strippedMessage).find()) {
            personal = this.personalDamage.getOrDefault("Nylocas Vasilias", 0).intValue();
            total = this.totalDamage.getOrDefault("Nylocas Vasilias", 0).intValue();
            int healed = this.totalHealing.getOrDefault("Nylocas Vasilias", 0);
            healing = "Total Healing - " + DMG_FORMAT.format(healed);
            double percent = personal / total * 100.0;
            roomTime2 = "";
            Object splits = "";
            damage = "";
            messages.clear();
            if (this.nyloStartTick > 0) {
                int roomTicks = this.client.getTickCount() - this.nyloStartTick;
                roomTime2 = this.formatTime(roomTicks);
                splits = "Waves - " + this.formatTime(this.waveTime) + "</br>Cleanup - " + this.formatTime(this.cleanupTime) + " (" + this.formatTime(this.cleanupTime - this.waveTime) + ")</br>Boss Spawn - " + this.formatTime(this.bossSpawnTime) + " (" + this.formatTime(this.bossSpawnTime - this.cleanupTime) + ")</br>Room Complete - " + roomTime2 + " (" + this.formatTime(roomTicks - this.bossSpawnTime) + ")";
                if (this.config.chatboxSplits()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Waves - ").append(Color.RED, this.formatTime(this.waveTime)).build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Cleanup - ").append(Color.RED, this.formatTime(this.cleanupTime) + " (" + this.formatTime(this.cleanupTime - this.waveTime) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Boss Spawn - ").append(Color.RED, this.formatTime(this.bossSpawnTime) + " (" + this.formatTime(this.bossSpawnTime - this.cleanupTime) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Room Complete - ").append(Color.RED, roomTime2 + " (" + this.formatTime(roomTicks - this.bossSpawnTime) + ")").build());
                }
            }
            if (personal > 0.0) {
                damage = "Personal Boss Damage - " + DMG_FORMAT.format(personal);
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Personal Boss Damage - ").append(Color.RED, DMG_FORMAT.format(personal) + " (" + DECIMAL_FORMAT.format(percent) + "%)").build());
                }
            }
            if (this.config.chatboxHealed()) {
                messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total Healing - ").append(Color.RED, DMG_FORMAT.format(healed)).build());
            }
            this.nyloInfoBox = this.createInfoBox(25750, "Nylocas", roomTime2, DECIMAL_FORMAT.format(percent), (String)damage, (String)splits, healing);
            this.infoBoxManager.addInfoBox((InfoBox)this.nyloInfoBox);
            this.resetNylo();
        } else if (SOTETSEG_WAVE.matcher(strippedMessage).find()) {
            personal = this.personalDamage.getOrDefault("Sotetseg", 0).intValue();
            total = this.totalDamage.getOrDefault("Sotetseg", 0).intValue();
            double percent = personal / total * 100.0;
            roomTime = "";
            Object splits = "";
            Object damage3 = "";
            messages.clear();
            if (this.soteStartTick > 0) {
                int roomTicks = this.client.getTickCount() - this.soteStartTick;
                roomTime = this.formatTime(roomTicks);
                splits = "66% - " + this.formatTime(this.sote66time) + "</br>33% - " + this.formatTime(this.sote33time) + " (" + this.formatTime(this.sote33time - this.sote66time) + ")</br>Room Complete - " + (String)roomTime + " (" + this.formatTime(roomTicks - this.sote33time) + ")";
                if (this.config.chatboxSplits()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("66% - ").append(Color.RED, this.formatTime(this.sote66time)).build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("33% - ").append(Color.RED, this.formatTime(this.sote33time) + " (" + this.formatTime(this.sote33time - this.sote66time) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Room Complete - ").append(Color.RED, (String)roomTime + " (" + this.formatTime(roomTicks - this.sote33time) + ")").build());
                }
            }
            if (personal > 0.0) {
                damage3 = "Personal Boss Damage - " + DMG_FORMAT.format(personal);
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Personal Boss Damage - ").append(Color.RED, DMG_FORMAT.format(personal) + " (" + DECIMAL_FORMAT.format(percent) + "%)").build());
                }
            }
            this.soteInfoBox = this.createInfoBox(25751, "Sotetseg", (String)roomTime, DECIMAL_FORMAT.format(percent), (String)damage3, (String)splits, "");
            this.infoBoxManager.addInfoBox((InfoBox)this.soteInfoBox);
            this.resetSote();
        } else if (XARPUS_WAVE.matcher(strippedMessage).find()) {
            personal = this.personalDamage.getOrDefault("Xarpus", 0).intValue();
            total = this.totalDamage.getOrDefault("Xarpus", 0).intValue();
            int healed = this.totalHealing.getOrDefault("Xarpus", 0);
            healing = "Total Healing - " + DMG_FORMAT.format(healed);
            double xarpusPostScreech = personal - (double)this.xarpusPreScreech;
            double personalPercent = personal / total * 100.0;
            double preScreechPercent = (double)this.xarpusPreScreech / (double)this.xarpusPreScreechTotal * 100.0;
            double postScreechPercent = xarpusPostScreech / (total - (double)this.xarpusPreScreechTotal) * 100.0;
            String roomTime3 = "";
            Object splits = "";
            Object damage4 = "";
            messages.clear();
            if (this.xarpusStartTick > 0) {
                int roomTicks = this.client.getTickCount() - this.xarpusStartTick;
                roomTime3 = this.formatTime(roomTicks);
                splits = "Recovery Phase - " + this.formatTime(this.xarpusRecoveryTime) + "</br>Screech Time - " + this.formatTime(this.xarpusAcidTime) + " (" + this.formatTime(this.xarpusAcidTime - this.xarpusRecoveryTime) + ")</br>Room Complete - " + roomTime3 + " (" + this.formatTime(roomTicks - this.xarpusAcidTime) + ")";
                if (this.config.chatboxSplits()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Recovery Phase - ").append(Color.RED, this.formatTime(this.xarpusRecoveryTime)).build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Screech Time - ").append(Color.RED, this.formatTime(this.xarpusAcidTime) + " (" + this.formatTime(this.xarpusAcidTime - this.xarpusRecoveryTime) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Room Complete - ").append(Color.RED, roomTime3 + " (" + this.formatTime(roomTicks - this.xarpusAcidTime) + ")").build());
                }
            }
            if (this.xarpusPreScreech > 0) {
                damage4 = (String)damage4 + "Pre Screech Damage - " + DMG_FORMAT.format(this.xarpusPreScreech) + " (" + DECIMAL_FORMAT.format(preScreechPercent) + "%)</br>";
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Pre Screech Damage - ").append(Color.RED, DMG_FORMAT.format(this.xarpusPreScreech) + " (" + DECIMAL_FORMAT.format(preScreechPercent) + "%)").build());
                }
            }
            if (xarpusPostScreech > 0.0) {
                damage4 = (String)damage4 + "Post Screech Damage - " + DMG_FORMAT.format(xarpusPostScreech) + " (" + DECIMAL_FORMAT.format(postScreechPercent) + "%)</br>";
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Post Screech Damage - ").append(Color.RED, DMG_FORMAT.format(xarpusPostScreech) + " (" + DECIMAL_FORMAT.format(postScreechPercent) + "%)").build());
                }
            }
            if (personal > 0.0) {
                damage4 = (String)damage4 + "Personal Boss Damage - " + DMG_FORMAT.format(personal);
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Personal Boss Damage - ").append(Color.RED, DMG_FORMAT.format(personal) + " (" + DECIMAL_FORMAT.format(personalPercent) + "%)").build());
                }
            }
            if (this.config.chatboxHealed()) {
                messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total Healed - ").append(Color.RED, DMG_FORMAT.format(healed)).build());
            }
            this.xarpusInfoBox = this.createInfoBox(25752, "Xarpus", roomTime3, DECIMAL_FORMAT.format(personalPercent), (String)damage4, (String)splits, healing);
            this.infoBoxManager.addInfoBox((InfoBox)this.xarpusInfoBox);
            this.resetXarpus();
        } else if (COMPLETION.matcher(strippedMessage).find()) {
            personal = this.personalDamage.getOrDefault("Verzik Vitur", 0).intValue();
            total = this.totalDamage.getOrDefault("Verzik Vitur", 0).intValue();
            double p3personal = (double)this.personalDamage.getOrDefault("Verzik Vitur", 0).intValue() - (this.verzikP1personal + this.verzikP2personal);
            double p3total = (double)this.totalDamage.getOrDefault("Verzik Vitur", 0).intValue() - (this.verzikP1total + this.verzikP2total);
            double p3healed = (double)this.totalHealing.getOrDefault("Verzik Vitur", 0).intValue() - this.verzikP2healed;
            double healed = this.totalHealing.getOrDefault("Verzik Vitur", 0).intValue();
            double p3percent = p3personal / p3total * 100.0;
            double p1percent = this.verzikP1personal / this.verzikP1total * 100.0;
            double p2percent = this.verzikP2personal / this.verzikP2total * 100.0;
            double percent = personal / total * 100.0;
            String roomTime4 = "";
            Object splits = "";
            Object damage5 = "";
            String healing2 = "P2 Healed - " + DMG_FORMAT.format(this.verzikP2healed) + "</br>P3 Healed - " + DMG_FORMAT.format(p3healed) + "</br>Total Healed - " + DMG_FORMAT.format(healed);
            messages.clear();
            if (this.verzikStartTick > 0) {
                int roomTicks = this.client.getTickCount() - this.verzikStartTick;
                roomTime4 = this.formatTime(roomTicks);
                splits = "P1 - " + this.formatTime(this.verzikP1time) + "</br>P2 - " + this.formatTime(this.verzikP2time) + " (" + this.formatTime(this.verzikP2time - this.verzikP1time) + ")</br>P3 - " + roomTime4 + " (" + this.formatTime(roomTicks - this.verzikP2time) + ")";
                if (this.config.chatboxSplits()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P1 - ").append(Color.RED, this.formatTime(this.verzikP1time)).build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P2 - ").append(Color.RED, this.formatTime(this.verzikP2time) + " (" + this.formatTime(this.verzikP2time - this.verzikP1time) + ")").build());
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P3 - ").append(Color.RED, roomTime4 + " (" + this.formatTime(roomTicks - this.verzikP2time) + ")").build());
                }
            }
            if (this.verzikP1personal > 0.0) {
                damage5 = (String)damage5 + "P1 Personal Damage - " + DMG_FORMAT.format(this.verzikP1personal) + " (" + DECIMAL_FORMAT.format(p1percent) + "%)</br>";
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P1 Personal Damage - ").append(Color.RED, DMG_FORMAT.format(this.verzikP1personal) + " (" + DECIMAL_FORMAT.format(p1percent) + "%)").build());
                }
            }
            if (this.verzikP2personal > 0.0) {
                damage5 = (String)damage5 + "P2 Personal Damage - " + DMG_FORMAT.format(this.verzikP2personal) + " (" + DECIMAL_FORMAT.format(p2percent) + "%)</br>";
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P2 Personal Damage - ").append(Color.RED, DMG_FORMAT.format(this.verzikP2personal) + " (" + DECIMAL_FORMAT.format(p2percent) + "%)").build());
                }
            }
            if (p3personal > 0.0) {
                damage5 = (String)damage5 + "P3 Personal Damage - " + DMG_FORMAT.format(p3personal) + " (" + DECIMAL_FORMAT.format(p3percent) + "%)</br>";
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P3 Personal Damage - ").append(Color.RED, DMG_FORMAT.format(p3personal) + " (" + DECIMAL_FORMAT.format(p3percent) + "%)").build());
                }
            }
            if (personal > 0.0) {
                damage5 = (String)damage5 + "Total Personal Damage - " + DMG_FORMAT.format(personal);
                if (this.config.chatboxDmg()) {
                    messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total Personal Damage - ").append(Color.RED, DMG_FORMAT.format(personal) + " (" + DECIMAL_FORMAT.format(percent) + "%)").build());
                }
            }
            if (this.config.chatboxHealed()) {
                messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P2 Healed - ").append(Color.RED, DMG_FORMAT.format(this.verzikP2healed)).build());
                messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("P3 Healed - ").append(Color.RED, DMG_FORMAT.format(p3healed)).build());
                messages.add(new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Total Healed - ").append(Color.RED, DMG_FORMAT.format(healed)).build());
            }
            this.verzikInfoBox = this.createInfoBox(22473, "Verzik", roomTime4, DECIMAL_FORMAT.format(percent), (String)damage5, (String)splits, healing2);
            this.infoBoxManager.addInfoBox((InfoBox)this.verzikInfoBox);
            this.resetVerzik();
        }
        if (!messages.isEmpty()) {
            for (String m : messages) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(m).build());
            }
            messages.clear();
        }
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        if (!this.tobInside) {
            return;
        }
        NPC npc = event.getNpc();
        int npcId = npc.getId();
        switch (npcId) {
            case 8361: 
            case 10815: 
            case 10823: {
                if (this.maidenStartTick == -1) break;
                this.maiden70time = this.client.getTickCount() - this.maidenStartTick;
                break;
            }
            case 8362: 
            case 10816: 
            case 10824: {
                if (this.maidenStartTick == -1) break;
                this.maiden50time = this.client.getTickCount() - this.maidenStartTick;
                break;
            }
            case 8363: 
            case 10817: 
            case 10825: {
                if (this.maidenStartTick == -1) break;
                this.maiden30time = this.client.getTickCount() - this.maidenStartTick;
                break;
            }
            case 8388: 
            case 10865: 
            case 10868: {
                if (this.soteStartTick != -1) break;
                this.soteStartTick = this.client.getTickCount();
                break;
            }
            case 8387: 
            case 10864: 
            case 10867: {
                if (this.soteStartTick == -1) break;
                if (!this.sote66) {
                    this.sote66time = this.client.getTickCount() - this.soteStartTick;
                    this.sote66 = true;
                    break;
                }
                if (this.sote33) break;
                this.sote33time = this.client.getTickCount() - this.soteStartTick;
                this.sote33 = true;
                break;
            }
            case 8339: 
            case 10767: 
            case 10771: {
                this.xarpusStartTick = this.client.getTickCount();
                break;
            }
            case 8340: 
            case 10768: 
            case 10772: {
                this.xarpusRecoveryTime = this.client.getTickCount() - this.xarpusStartTick;
                break;
            }
            case 8370: 
            case 10831: 
            case 10848: {
                this.verzikStartTick = this.client.getTickCount();
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.tobInside) {
            return;
        }
        NPC npc = event.getNpc();
        int npcId = npc.getId();
        switch (npcId) {
            case 8360: 
            case 10814: 
            case 10822: {
                this.maidenStartTick = this.client.getTickCount();
                break;
            }
            case 8358: 
            case 10790: 
            case 10811: {
                this.nyloStartTick = this.client.getTickCount();
                break;
            }
            case 8354: 
            case 10786: 
            case 10807: {
                this.bossSpawnTime = this.client.getTickCount() - this.nyloStartTick;
                break;
            }
            case 8371: 
            case 10832: 
            case 10849: {
                this.verzikP1time = this.client.getTickCount() - this.verzikStartTick;
                this.verzikP1personal = this.personalDamage.getOrDefault("Verzik Vitur", 0).intValue();
                this.verzikP1total = this.totalDamage.getOrDefault("Verzik Vitur", 0).intValue();
                break;
            }
            case 8373: 
            case 10834: 
            case 10851: {
                this.verzikP2time = this.client.getTickCount() - this.verzikStartTick;
                this.verzikP2personal = (double)this.personalDamage.getOrDefault("Verzik Vitur", 0).intValue() - this.verzikP1personal;
                this.verzikP2total = (double)this.totalDamage.getOrDefault("Verzik Vitur", 0).intValue() - this.verzikP1total;
                this.verzikP2healed = this.totalHealing.getOrDefault("Verzik Vitur", 0).intValue();
            }
        }
        if (!NYLOCAS_IDS.contains(npcId) || this.prevRegion != 13122) {
            return;
        }
        ++this.currentNylos;
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)npc.getLocalLocation());
        Point spawnLoc = new Point(worldPoint.getRegionX(), worldPoint.getRegionY());
        if (!NYLOCAS_VALID_SPAWNS.contains(spawnLoc)) {
            return;
        }
        if (!this.waveThisTick) {
            ++this.nyloWave;
            this.waveThisTick = true;
        }
        if (this.nyloWave == 31 && !this.nyloWavesFinished) {
            this.waveTime = this.client.getTickCount() - this.nyloStartTick;
            this.nyloWavesFinished = true;
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (!this.tobInside) {
            return;
        }
        NPC npc = event.getNpc();
        int npcId = npc.getId();
        if (!NYLOCAS_IDS.contains(npcId) || this.prevRegion != 13122) {
            return;
        }
        --this.currentNylos;
        if (this.nyloWavesFinished && !this.nyloCleanupFinished && this.currentNylos == 0) {
            this.cleanupTime = this.client.getTickCount() - this.nyloStartTick;
            this.nyloCleanupFinished = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.tobInside) {
            return;
        }
        if (this.waveThisTick) {
            this.waveThisTick = false;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOADING) {
            return;
        }
        boolean prevInstance = this.instanced;
        this.instanced = this.client.isInInstancedRegion();
        if (prevInstance && !this.instanced) {
            this.resetAll();
            this.resetAllInfoBoxes();
        } else if (!prevInstance && this.instanced) {
            this.resetAll();
            this.resetAllInfoBoxes();
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (!this.tobInside) {
            return;
        }
        Actor actor = event.getActor();
        if (!(actor instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)actor;
        String npcName = npc.getName();
        if (npcName == null || !BOSS_NAMES.contains(npcName)) {
            return;
        }
        npcName = Text.removeTags((String)npcName);
        Hitsplat hitsplat = event.getHitsplat();
        if (hitsplat.isMine()) {
            int myDmg = this.personalDamage.getOrDefault(npcName, 0);
            int totalDmg = this.totalDamage.getOrDefault(npcName, 0);
            this.personalDamage.put(npcName, myDmg += hitsplat.getAmount());
            this.totalDamage.put(npcName, totalDmg += hitsplat.getAmount());
        } else if (hitsplat.isOthers()) {
            int totalDmg = this.totalDamage.getOrDefault(npcName, 0);
            this.totalDamage.put(npcName, totalDmg += hitsplat.getAmount());
        } else if (hitsplat.getHitsplatType() == 6) {
            int healed = this.totalHealing.getOrDefault(npcName, 0);
            this.totalHealing.put(npcName, healed += hitsplat.getAmount());
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        Actor npc = event.getActor();
        if (!(npc instanceof NPC) || !this.tobInside) {
            return;
        }
        String overheadText = event.getOverheadText();
        String npcName = npc.getName();
        if (npcName != null && npcName.equals("Xarpus") && overheadText.equals("Screeeeech!")) {
            this.xarpusAcidTime = this.client.getTickCount() - this.xarpusStartTick;
            this.xarpusPreScreech = this.personalDamage.getOrDefault(npcName, 0);
            this.xarpusPreScreechTotal = this.totalDamage.getOrDefault(npcName, 0);
        }
    }

    private TheatreOfBloodStatsInfoBox createInfoBox(int itemId, String room, String time, String percent, String damage, String splits, String healed) {
        AsyncBufferedImage image = this.itemManager.getImage(itemId);
        return new TheatreOfBloodStatsInfoBox((BufferedImage)image, this.config, this, room, time, percent, damage, splits, healed);
    }

    private String formatTime(int ticks) {
        int millis = ticks * 600;
        String hundredths = String.valueOf(millis % 1000).substring(0, 1);
        if (this.preciseTimers) {
            return String.format("%d:%02d.%s", TimeUnit.MILLISECONDS.toMinutes(millis) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis) % TimeUnit.MINUTES.toSeconds(1L), hundredths);
        }
        return String.format("%d:%02d", TimeUnit.MILLISECONDS.toMinutes(millis) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis) % TimeUnit.MINUTES.toSeconds(1L));
    }

    private void resetMaiden() {
        this.maidenStartTick = -1;
        this.maiden70time = 0;
        this.maiden50time = 0;
        this.maiden30time = 0;
        this.personalDamage.remove("The Maiden of Sugadinti");
        this.totalDamage.remove("The Maiden of Sugadinti");
        this.totalHealing.remove("The Maiden of Sugadinti");
    }

    private void resetBloat() {
        this.personalDamage.remove("Pestilent Bloat");
        this.totalDamage.remove("Pestilent Bloat");
    }

    private void resetNylo() {
        this.nyloStartTick = -1;
        this.currentNylos = 0;
        this.nyloWavesFinished = false;
        this.nyloCleanupFinished = false;
        this.waveTime = 0;
        this.cleanupTime = 0;
        this.bossSpawnTime = 0;
        this.waveThisTick = false;
        this.nyloWave = 0;
        this.personalDamage.remove("Nylocas Vasilias");
        this.totalDamage.remove("Nylocas Vasilias");
    }

    private void resetSote() {
        this.soteStartTick = -1;
        this.sote66 = false;
        this.sote66time = 0;
        this.sote33 = false;
        this.sote33time = 0;
        this.personalDamage.remove("Sotetseg");
        this.totalDamage.remove("Sotetseg");
    }

    private void resetXarpus() {
        this.xarpusStartTick = -1;
        this.xarpusRecoveryTime = 0;
        this.xarpusAcidTime = 0;
        this.xarpusPreScreech = 0;
        this.xarpusPreScreechTotal = 0;
        this.personalDamage.remove("Xarpus");
        this.totalDamage.remove("Xarpus");
        this.totalHealing.remove("Xarpus");
    }

    private void resetVerzik() {
        this.verzikStartTick = -1;
        this.verzikP1time = 0;
        this.verzikP2time = 0;
        this.verzikP1personal = 0.0;
        this.verzikP1total = 0.0;
        this.verzikP2personal = 0.0;
        this.verzikP2total = 0.0;
        this.verzikP2healed = 0.0;
        this.personalDamage.clear();
        this.totalDamage.clear();
        this.totalHealing.clear();
    }

    private void resetAll() {
        this.resetMaiden();
        this.resetBloat();
        this.resetNylo();
        this.resetSote();
        this.resetXarpus();
        this.resetVerzik();
    }

    private void resetAllInfoBoxes() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.maidenInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.bloatInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.nyloInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.soteInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.xarpusInfoBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.verzikInfoBox);
    }
}

