/*
 * Decompiled with CFR 0.152.
 */
package com.funnybossnames;

import com.funnybossnames.Boss;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Funny Boss Names")
public class FunnyBossNamesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FunnyBossNamesPlugin.class);
    @Inject
    private Client client;
    private List<Boss> bosses;

    @Subscribe
    public void onClientTick(ClientTick event) {
        Widget bossName = this.client.getWidget(303, 9);
        Widget colLogNameBig = this.client.getWidget(621, 19);
        Widget scoreBoardName = this.client.getWidget(817, 6);
        for (Boss boss : this.bosses) {
            if (bossName != null && bossName.getText().contains(boss.getBossName())) {
                bossName.setText(bossName.getText().replace(bossName.getText(), boss.getNewName()));
            }
            if (colLogNameBig != null && colLogNameBig.getChild(0) != null && colLogNameBig.getChild(0).getText().contains(boss.getBossName())) {
                colLogNameBig = colLogNameBig.getChild(0);
                colLogNameBig.setText(colLogNameBig.getText().replace(colLogNameBig.getText(), boss.getNewName()));
            }
            if (scoreBoardName == null || !scoreBoardName.getText().contains(boss.getBossName())) continue;
            scoreBoardName.setText(scoreBoardName.getText().replace(scoreBoardName.getText(), boss.getNewName()));
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        for (Boss boss : this.bosses) {
            if (!event.getMenuEntry().getTarget().toLowerCase().contains(boss.getBossName().toLowerCase())) continue;
            event.getMenuEntry().setTarget(event.getTarget().replace(boss.getBossName(), boss.getNewName()));
        }
    }

    protected void shutDown() {
        log.info("Funny boss names plugin stopped!");
    }

    protected void startUp() throws Exception {
        log.info("Funny boss names plugin started!");
        this.bosses = Arrays.asList(Boss.values());
    }
}

