/*
 * Decompiled with CFR 0.152.
 */
package com.weightcalc;

import com.weightcalc.WeightCalcConfig;
import com.weightcalc.WeightCalcMessage;
import com.weightcalc.WeightCalcPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightCalcWidgetItemOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(WeightCalcWidgetItemOverlay.class);
    private final WeightCalcConfig config;
    private final WeightCalcPlugin plugin;

    @Inject
    private WeightCalcWidgetItemOverlay(WeightCalcPlugin plugin, WeightCalcConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
        this.showOnEquipment();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        graphics.setFont(FontManager.getRunescapeSmallFont());
        WeightCalcMessage wm = WeightCalcPlugin.getWm();
        if (wm != null && itemId == wm.getItemId()) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            TextComponent textComponent = new TextComponent();
            if (wm.isWithdrawMore()) {
                textComponent.setColor(new Color(65280));
            } else {
                textComponent.setColor(new Color(0xFF0000));
            }
            textComponent.setText("****");
            textComponent.setPosition(new Point(bounds.x - 1, bounds.y - 1 + bounds.height));
            textComponent.render(graphics);
        }
    }
}

