/*
 * Decompiled with CFR 0.152.
 */
package com.weightcalc;

import com.google.inject.Provides;
import com.weightcalc.WeightCalcConfig;
import com.weightcalc.WeightCalcMessage;
import com.weightcalc.WeightCalcOverlayPanel;
import com.weightcalc.WeightCalcWidgetItemOverlay;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Weight Calculator", description="Helps calculate weights", tags={"weight"})
public class WeightCalcPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WeightCalcPlugin.class);
    @Inject
    private WeightCalcWidgetItemOverlay widgetItemOverlay;
    @Inject
    private WeightCalcOverlayPanel overlayPanel;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private WeightCalcConfig config;
    static final String CONFIG_GROUP_KEY = "weightcalc";
    public static int THOUSANDTH_KG_ID;
    public static int HUNDREDTH_KG_ID;
    public static int TENTH_KG_ID;
    public static int HALF_KG_ID;
    public static int COINS_ID;
    public static final BigDecimal THOUSANDTH_KG_WEIGHT;
    public static final BigDecimal HUNDREDTH_KG_WEIGHT;
    public static final BigDecimal TENTH_KG_WEIGHT;
    public static final BigDecimal HALF_KG_WEIGHT;
    public static final int STATE_EQUIPPED = 0;
    public static final int STATE_EMPTY = 1;
    public static final int STATE_ITEM_UNKNOWN = 2;
    public static final int STATE_READY = 3;
    public static final int STATE_TOO_MANY_ITEMS = 4;
    public static final int STATE_WEIGHING = 5;
    public static final int STATE_UNKNOWN = 6;
    private static BigDecimal aloneWeightBD;
    private static BigDecimal minWeight;
    private static BigDecimal maxWeight;
    private static final int[] itemCounts;
    private static WeightCalcMessage wm;
    private static Item currentItem;
    int state = 1;
    private static int aloneWeight;

    @Provides
    WeightCalcConfig getConfig(ConfigManager configManager) {
        return (WeightCalcConfig)configManager.getConfig(WeightCalcConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.widgetItemOverlay);
        this.overlayManager.add((Overlay)this.overlayPanel);
        THOUSANDTH_KG_ID = this.config.thousandthKgConfig().getId();
        HUNDREDTH_KG_ID = this.config.hundredthKgConfig().getId();
        TENTH_KG_ID = this.config.tenthKgConfig().getId();
        HALF_KG_ID = this.config.halfKgConfig().getId();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.widgetItemOverlay);
        this.overlayManager.remove((Overlay)this.overlayPanel);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        switch (event.getKey()) {
            case "0.500": {
                HALF_KG_ID = this.config.halfKgConfig().getId();
                break;
            }
            case "0.100": {
                TENTH_KG_ID = this.config.tenthKgConfig().getId();
                break;
            }
            case "0.010": {
                HUNDREDTH_KG_ID = this.config.hundredthKgConfig().getId();
                break;
            }
            case "0.001": {
                THOUSANDTH_KG_ID = this.config.thousandthKgConfig().getId();
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (InventoryID.INVENTORY.getId() != event.getContainerId()) {
            return;
        }
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        ItemContainer equipmentContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (itemContainer == null) {
            return;
        }
        Item[] items = itemContainer.getItems();
        this.state = this.determineState(itemContainer, equipmentContainer);
        if (this.state == 0) {
            log.debug("STATE_EQUIPPED");
            currentItem = null;
            wm = null;
        } else if (this.state == 1) {
            log.debug("STATE_EMPTY");
            currentItem = null;
            wm = null;
        } else if (this.state == 2) {
            log.debug("STATE_ITEM_UNKNOWN");
            currentItem = null;
            wm = null;
        } else if (this.state == 3) {
            log.debug("STATE_READY");
            currentItem = this.getItemToWeigh(items);
            aloneWeight = this.client.getWeight();
            aloneWeightBD = new BigDecimal(aloneWeight);
            minWeight = new BigDecimal("0");
            maxWeight = minWeight.add(BigDecimal.ONE);
            wm = this.solve();
        } else if (this.state == 4) {
            log.debug("STATE_TOO_MANY_ITEMS");
            wm = null;
        } else if (this.state == 5) {
            log.debug("STATE_WEIGHING");
            int currentWeight = this.client.getWeight();
            BigDecimal extraWeight = this.getExtraWeight();
            log.debug("Extra weight: " + extraWeight);
            if (currentWeight < aloneWeight + 1) {
                if (minWeight.compareTo(extraWeight) <= 0) {
                    minWeight = extraWeight.add(THOUSANDTH_KG_WEIGHT);
                }
            } else if (currentWeight >= aloneWeight + 1 && maxWeight.compareTo(extraWeight) > 0) {
                maxWeight = extraWeight;
            }
            if (maxWeight.compareTo(minWeight) == 0) {
                wm = null;
                log.debug("Correct weight is: " + new BigDecimal(aloneWeight + 1).subtract(minWeight));
            } else {
                log.debug("Solving...");
                wm = this.solve();
            }
        } else if (this.state == 6) {
            log.debug("STATE UNKNOWN");
            currentItem = null;
            wm = null;
        }
    }

    private BigDecimal getExtraWeight() {
        BigDecimal extraWeight = BigDecimal.ZERO;
        extraWeight = extraWeight.add(THOUSANDTH_KG_WEIGHT.multiply(new BigDecimal(itemCounts[0])));
        extraWeight = extraWeight.add(HUNDREDTH_KG_WEIGHT.multiply(new BigDecimal(itemCounts[1])));
        extraWeight = extraWeight.add(TENTH_KG_WEIGHT.multiply(new BigDecimal(itemCounts[2])));
        extraWeight = extraWeight.add(HALF_KG_WEIGHT.multiply(new BigDecimal(itemCounts[3])));
        return extraWeight;
    }

    private int determineState(ItemContainer itemContainer, ItemContainer equipmentContainer) {
        Item[] equipment;
        Arrays.fill(itemCounts, 0);
        if (equipmentContainer != null && this.realSize(equipment = equipmentContainer.getItems()) != 0) {
            return 0;
        }
        if (itemContainer != null) {
            int id;
            Item[] items = itemContainer.getItems();
            if (this.realSize(items) == 0) {
                return 1;
            }
            if (this.realSize(items) == 1 && (currentItem == null || this.getItemToWeigh(items).getId() != currentItem.getId()) && (id = this.getItemToWeigh(items).getId()) != HALF_KG_ID && id != TENTH_KG_ID && id != HUNDREDTH_KG_ID && id != THOUSANDTH_KG_ID) {
                return 3;
            }
            if (this.realSize(items) >= 1) {
                int nonWeighingItemCount = 0;
                boolean itemWeighedInInventory = false;
                for (Item item : items) {
                    int id2 = item.getId();
                    if (id2 == THOUSANDTH_KG_ID) {
                        itemCounts[0] = itemCounts[0] + 1;
                    } else if (id2 == HUNDREDTH_KG_ID) {
                        itemCounts[1] = itemCounts[1] + 1;
                    } else if (id2 == TENTH_KG_ID) {
                        itemCounts[2] = itemCounts[2] + 1;
                    } else if (id2 == HALF_KG_ID) {
                        itemCounts[3] = itemCounts[3] + 1;
                    } else {
                        if (id2 == -1) continue;
                        if (item.getId() != COINS_ID) {
                            ++nonWeighingItemCount;
                        }
                    }
                    if (currentItem == null || item.getId() != currentItem.getId()) continue;
                    itemWeighedInInventory = true;
                }
                if (nonWeighingItemCount > 1) {
                    return 4;
                }
                if (!itemWeighedInInventory) {
                    return 2;
                }
                return 5;
            }
        }
        return 6;
    }

    private int realSize(Item[] items) {
        int size = 0;
        for (Item item : items) {
            if (item.getId() == -1 || item.getId() == COINS_ID) continue;
            ++size;
        }
        return size;
    }

    private Item getItemToWeigh(Item[] items) {
        for (Item item : items) {
            if (item.getId() == -1 || item.getId() == COINS_ID) continue;
            return item;
        }
        return items[0];
    }

    private WeightCalcMessage solve() {
        int totalRocks = 10;
        int totalKeys = 9;
        int totalBones = 4;
        int totalBalls = 1;
        int remainingRocks = totalRocks - itemCounts[0];
        int remainingKeys = totalKeys - itemCounts[1];
        int remainingGroundBones = totalBones - itemCounts[2];
        int remainingGnomeballs = totalBalls - itemCounts[3];
        BigDecimal currentWeight = this.getExtraWeight();
        BigDecimal maxWeight = WeightCalcPlugin.getMaxWeight();
        BigDecimal minWeight = WeightCalcPlugin.getMinWeight();
        BigDecimal range = maxWeight.subtract(currentWeight);
        if (currentWeight.compareTo(minWeight) <= 0) {
            if (range.compareTo(HALF_KG_WEIGHT) > 0 && remainingGnomeballs > 0) {
                return new WeightCalcMessage(HALF_KG_ID, true);
            }
            if (range.compareTo(TENTH_KG_WEIGHT) > 0 && remainingGroundBones > 0) {
                return new WeightCalcMessage(TENTH_KG_ID, true);
            }
            if (range.compareTo(HUNDREDTH_KG_WEIGHT) > 0 && remainingKeys > 0) {
                return new WeightCalcMessage(HUNDREDTH_KG_ID, true);
            }
            if (range.compareTo(THOUSANDTH_KG_WEIGHT) >= 0 && remainingRocks > 0) {
                return new WeightCalcMessage(THOUSANDTH_KG_ID, true);
            }
        } else {
            if (remainingRocks < totalRocks) {
                return new WeightCalcMessage(THOUSANDTH_KG_ID, false);
            }
            if (remainingKeys < totalKeys) {
                return new WeightCalcMessage(HUNDREDTH_KG_ID, false);
            }
            if (remainingGroundBones < totalBones) {
                return new WeightCalcMessage(TENTH_KG_ID, false);
            }
            if (remainingGnomeballs < totalBalls) {
                return new WeightCalcMessage(HALF_KG_ID, false);
            }
        }
        return null;
    }

    public static BigDecimal getAloneWeightBD() {
        return aloneWeightBD;
    }

    public static BigDecimal getMinWeight() {
        return minWeight;
    }

    public static BigDecimal getMaxWeight() {
        return maxWeight;
    }

    public static int[] getItemCounts() {
        return itemCounts;
    }

    public static WeightCalcMessage getWm() {
        return wm;
    }

    public static Item getCurrentItem() {
        return currentItem;
    }

    public int getState() {
        return this.state;
    }

    static {
        COINS_ID = 995;
        THOUSANDTH_KG_WEIGHT = new BigDecimal("0.001");
        HUNDREDTH_KG_WEIGHT = new BigDecimal("0.010");
        TENTH_KG_WEIGHT = new BigDecimal("0.100");
        HALF_KG_WEIGHT = new BigDecimal("0.500");
        aloneWeightBD = new BigDecimal("0");
        minWeight = new BigDecimal("0");
        maxWeight = new BigDecimal("0");
        itemCounts = new int[4];
        wm = null;
        currentItem = null;
        aloneWeight = 0;
    }
}

