/*
 * Decompiled with CFR 0.152.
 */
package com.weightcalc;

import com.weightcalc.WeightCalcConfig;
import com.weightcalc.WeightCalcPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.inject.Inject;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;

public class WeightCalcOverlayPanel
extends OverlayPanel {
    private final WeightCalcConfig config;
    private final WeightCalcPlugin plugin;
    @Inject
    private ItemManager itemManager;

    @Inject
    private WeightCalcOverlayPanel(WeightCalcPlugin plugin, WeightCalcConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
    }

    private void addTextToOverlayPanel(String text) {
        this.panelComponent.getChildren().add(LineComponent.builder().left(text).build());
    }

    public Dimension render(Graphics2D graphics) {
        BigDecimal minWeight = WeightCalcPlugin.getMinWeight().setScale(3, RoundingMode.HALF_UP);
        BigDecimal maxWeight = WeightCalcPlugin.getMaxWeight().setScale(3, RoundingMode.HALF_UP);
        BigDecimal aloneWeight = WeightCalcPlugin.getAloneWeightBD();
        int state = this.plugin.getState();
        this.panelComponent.getChildren().clear();
        if (state == 0) {
            this.addTextToOverlayPanel("Deposit all equipped items and items in your inventory.");
        } else if (state == 1) {
            this.addTextToOverlayPanel("Add the item to weigh to your inventory.");
        } else if (state == 2) {
            this.addTextToOverlayPanel("Empty your inventory.");
        } else if (state == 4) {
            this.addTextToOverlayPanel("Remove extra non-weighing items from your inventory.");
        } else if (state == 6) {
            this.addTextToOverlayPanel("Please restart the plugin and try again.");
        } else {
            Item currentItem = WeightCalcPlugin.getCurrentItem();
            ItemComposition item = this.itemManager.getItemComposition(currentItem.getId());
            this.addTextToOverlayPanel("Weighing: " + item.getName());
            this.addTextToOverlayPanel("");
            if (WeightCalcPlugin.getWm() != null) {
                ItemComposition weighingItem = this.itemManager.getItemComposition(WeightCalcPlugin.getWm().getItemId());
                String message = (WeightCalcPlugin.getWm().isWithdrawMore() ? "Withdraw " : "Deposit ") + weighingItem.getName();
                this.addTextToOverlayPanel(message);
            }
            if (minWeight.compareTo(maxWeight) == 0) {
                this.addTextToOverlayPanel("Final weight: " + BigDecimal.ONE.subtract(maxWeight).add(aloneWeight).toString());
            } else if (this.config.showWeightsRange()) {
                this.addTextToOverlayPanel("Possible weights: " + BigDecimal.ONE.subtract(maxWeight).add(aloneWeight) + " - " + BigDecimal.ONE.subtract(minWeight).add(aloneWeight));
            }
        }
        return super.render(graphics);
    }
}

