/*
 * Decompiled with CFR 0.152.
 */
package shortestpath.pathfinder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import shortestpath.ShortestPathPlugin;
import shortestpath.Util;
import shortestpath.pathfinder.FlagMap;

public class SplitFlagMap {
    private static RegionExtent regionExtents;
    private final byte[] regionMapPlaneCounts;
    private final FlagMap[] regionMaps;
    private final int widthInclusive = regionExtents.getWidth() + 1;

    public SplitFlagMap(Map<Integer, byte[]> compressedRegions) {
        int heightInclusive = regionExtents.getHeight() + 1;
        this.regionMaps = new FlagMap[this.widthInclusive * heightInclusive];
        this.regionMapPlaneCounts = new byte[this.regionMaps.length];
        for (Map.Entry<Integer, byte[]> entry : compressedRegions.entrySet()) {
            FlagMap flagMap;
            int pos = entry.getKey();
            int x = SplitFlagMap.unpackX(pos);
            int y = SplitFlagMap.unpackY(pos);
            int index = this.getIndex(x, y);
            this.regionMaps[index] = flagMap = new FlagMap(x * 64, y * 64, entry.getValue());
            this.regionMapPlaneCounts[index] = flagMap.getPlaneCount();
        }
    }

    public boolean get(int x, int y, int z, int flag) {
        int index = this.getIndex(x / 64, y / 64);
        if (index < 0 || index >= this.regionMaps.length || this.regionMaps[index] == null) {
            return false;
        }
        return this.regionMaps[index].get(x, y, z, flag);
    }

    private int getIndex(int regionX, int regionY) {
        return regionX - regionExtents.getMinX() + (regionY - regionExtents.getMinY()) * this.widthInclusive;
    }

    public static int unpackX(int position) {
        return position & 0xFFFF;
    }

    public static int unpackY(int position) {
        return position >> 16 & 0xFFFF;
    }

    public static int packPosition(int x, int y) {
        return x & 0xFFFF | (y & 0xFFFF) << 16;
    }

    public static SplitFlagMap fromResources() {
        HashMap<Integer, byte[]> compressedRegions = new HashMap<Integer, byte[]>();
        try (ZipInputStream in = new ZipInputStream(ShortestPathPlugin.class.getResourceAsStream("/collision-map.zip"));){
            ZipEntry entry;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = 0;
            int maxY = 0;
            while ((entry = in.getNextEntry()) != null) {
                String[] n = entry.getName().split("_");
                int x = Integer.parseInt(n[0]);
                int y = Integer.parseInt(n[1]);
                minX = Math.min(minX, x);
                minY = Math.min(minY, y);
                maxX = Math.max(maxX, x);
                maxY = Math.max(maxY, y);
                compressedRegions.put(SplitFlagMap.packPosition(x, y), Util.readAllBytes(in));
            }
            regionExtents = new RegionExtent(minX, minY, maxX, maxY);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SplitFlagMap(compressedRegions);
    }

    public static RegionExtent getRegionExtents() {
        return regionExtents;
    }

    public byte[] getRegionMapPlaneCounts() {
        return this.regionMapPlaneCounts;
    }

    public static class RegionExtent {
        public final int minX;
        public final int minY;
        public final int maxX;
        public final int maxY;

        public int getWidth() {
            return this.maxX - this.minX;
        }

        public int getHeight() {
            return this.maxY - this.minY;
        }

        public RegionExtent(int minX, int minY, int maxX, int maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxY() {
            return this.maxY;
        }
    }
}

