/*
 * Decompiled with CFR 0.152.
 */
package shortestpath.pathfinder;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.runelite.api.coords.WorldPoint;
import shortestpath.WorldPointUtil;

public class Node {
    public final int packedPosition;
    public final Node previous;
    public final int cost;

    public Node(WorldPoint position, Node previous, int wait) {
        this.packedPosition = WorldPointUtil.packWorldPoint(position);
        this.previous = previous;
        this.cost = this.cost(previous, wait);
    }

    public Node(WorldPoint position, Node previous) {
        this(position, previous, 0);
    }

    public Node(int packedPosition, Node previous, int wait) {
        this.packedPosition = packedPosition;
        this.previous = previous;
        this.cost = this.cost(previous, wait);
    }

    public Node(int packedPosition, Node previous) {
        this(packedPosition, previous, 0);
    }

    public List<WorldPoint> getPath() {
        LinkedList<WorldPoint> path = new LinkedList<WorldPoint>();
        Node node = this;
        while (node != null) {
            WorldPoint position = WorldPointUtil.unpackWorldPoint(node.packedPosition);
            path.add(0, position);
            node = node.previous;
        }
        return new ArrayList<WorldPoint>(path);
    }

    public List<Integer> getPathPacked() {
        LinkedList<Integer> path = new LinkedList<Integer>();
        Node node = this;
        while (node != null) {
            path.add(0, node.packedPosition);
            node = node.previous;
        }
        return new ArrayList<Integer>(path);
    }

    private int cost(Node previous, int wait) {
        int previousCost = 0;
        int distance = 0;
        if (previous != null) {
            boolean isTransport;
            previousCost = previous.cost;
            distance = WorldPointUtil.distanceBetween(previous.packedPosition, this.packedPosition);
            int previousPlane = WorldPointUtil.unpackWorldPlane(previous.packedPosition);
            int currentPlane = WorldPointUtil.unpackWorldPlane(previous.packedPosition);
            boolean bl = isTransport = distance > 1 || previousPlane != currentPlane;
            if (isTransport) {
                distance = wait;
            }
        }
        return previousCost + distance;
    }
}

