/*
 * Decompiled with CFR 0.152.
 */
package shortestpath;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.runelite.api.Quest;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import shortestpath.ShortestPathPlugin;
import shortestpath.Util;

public class Transport {
    private static final List<WorldPoint> fairyRings = new ArrayList<WorldPoint>();
    private static final List<String> fairyRingCodes = new ArrayList<String>();
    private final WorldPoint origin;
    private final WorldPoint destination;
    private final int[] skillLevels = new int[Skill.values().length];
    private List<Quest> quests = new ArrayList<Quest>();
    private boolean isAgilityShortcut;
    private boolean isGrappleShortcut;
    private boolean isBoat;
    private boolean isCanoe;
    private boolean isCharterShip;
    private boolean isShip;
    private boolean isFairyRing;
    private boolean isGnomeGlider;
    private boolean isSpiritTree;
    private boolean isTeleportationLever;
    private boolean isTeleportationPortal;
    private int wait;

    Transport(WorldPoint origin, WorldPoint destination) {
        this.origin = origin;
        this.destination = destination;
    }

    Transport(String line, TransportType transportType) {
        String DELIM = " ";
        String[] parts = line.split("\t");
        String[] parts_origin = parts[0].split(" ");
        String[] parts_destination = parts[1].split(" ");
        this.origin = new WorldPoint(Integer.parseInt(parts_origin[0]), Integer.parseInt(parts_origin[1]), Integer.parseInt(parts_origin[2]));
        this.destination = new WorldPoint(Integer.parseInt(parts_destination[0]), Integer.parseInt(parts_destination[1]), Integer.parseInt(parts_destination[2]));
        if (parts.length >= 4 && !parts[3].isEmpty()) {
            String[] skillRequirements;
            block0: for (String requirement : skillRequirements = parts[3].split(";")) {
                String[] levelAndSkill = requirement.split(" ");
                int level = Integer.parseInt(levelAndSkill[0]);
                String skillName = levelAndSkill[1];
                Skill[] skills = Skill.values();
                for (int i = 0; i < skills.length; ++i) {
                    if (!skills[i].getName().equals(skillName)) continue;
                    this.skillLevels[i] = level;
                    continue block0;
                }
            }
        }
        if (parts.length >= 6 && !parts[5].isEmpty()) {
            this.quests = Transport.findQuests(parts[5]);
        }
        if (parts.length >= 7 && !parts[6].isEmpty()) {
            this.wait = Integer.parseInt(parts[6]);
        }
        this.isAgilityShortcut = TransportType.AGILITY_SHORTCUT.equals((Object)transportType);
        this.isGrappleShortcut = this.isAgilityShortcut && (this.getRequiredLevel(Skill.RANGED) > 1 || this.getRequiredLevel(Skill.STRENGTH) > 1);
        this.isBoat = TransportType.BOAT.equals((Object)transportType);
        this.isCanoe = TransportType.CANOE.equals((Object)transportType);
        this.isCharterShip = TransportType.CHARTER_SHIP.equals((Object)transportType);
        this.isShip = TransportType.SHIP.equals((Object)transportType);
        this.isGnomeGlider = TransportType.GNOME_GLIDER.equals((Object)transportType);
        this.isSpiritTree = TransportType.SPIRIT_TREE.equals((Object)transportType);
        this.isTeleportationLever = TransportType.TELEPORTATION_LEVER.equals((Object)transportType);
        this.isTeleportationPortal = TransportType.TELEPORTATION_PORTAL.equals((Object)transportType);
    }

    public int getRequiredLevel(Skill skill) {
        return this.skillLevels[skill.ordinal()];
    }

    public boolean isQuestLocked() {
        return !this.quests.isEmpty();
    }

    private static List<Quest> findQuests(String questNamesCombined) {
        String[] questNames = questNamesCombined.split(";");
        ArrayList<Quest> quests = new ArrayList<Quest>();
        block0: for (String questName : questNames) {
            for (Quest quest : Quest.values()) {
                if (!quest.getName().equals(questName)) continue;
                quests.add(quest);
                continue block0;
            }
        }
        return quests;
    }

    private static void addTransports(Map<WorldPoint, List<Transport>> transports, String path, TransportType transportType) {
        try {
            String s = new String(Util.readAllBytes(ShortestPathPlugin.class.getResourceAsStream(path)), StandardCharsets.UTF_8);
            Scanner scanner = new Scanner(s);
            ArrayList<String> fairyRingsQuestNames = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#") || line.isBlank()) continue;
                if (TransportType.FAIRY_RING.equals((Object)transportType)) {
                    String[] p = line.split("\t");
                    fairyRings.add(new WorldPoint(Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2])));
                    fairyRingCodes.add(p.length >= 4 ? p[3].replaceAll("_", " ") : null);
                    fairyRingsQuestNames.add(p.length >= 7 ? p[6] : "");
                    continue;
                }
                Transport transport = new Transport(line, transportType);
                WorldPoint origin = transport.getOrigin();
                transports.computeIfAbsent(origin, k -> new ArrayList()).add(transport);
            }
            if (TransportType.FAIRY_RING.equals((Object)transportType)) {
                for (WorldPoint origin : fairyRings) {
                    for (int i = 0; i < fairyRings.size(); ++i) {
                        WorldPoint destination = fairyRings.get(i);
                        String questName = (String)fairyRingsQuestNames.get(i);
                        if (origin.equals((Object)destination)) continue;
                        Transport transport = new Transport(origin, destination);
                        transport.isFairyRing = true;
                        transport.wait = 5;
                        transports.computeIfAbsent(origin, k -> new ArrayList()).add(transport);
                        if (Strings.isNullOrEmpty((String)questName)) continue;
                        transport.quests = Transport.findQuests(questName);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HashMap<WorldPoint, List<Transport>> loadAllFromResources() {
        HashMap<WorldPoint, List<Transport>> transports = new HashMap<WorldPoint, List<Transport>>();
        fairyRings.clear();
        fairyRingCodes.clear();
        Transport.addTransports(transports, "/transports.txt", TransportType.TRANSPORT);
        Transport.addTransports(transports, "/agility_shortcuts.txt", TransportType.AGILITY_SHORTCUT);
        Transport.addTransports(transports, "/boats.txt", TransportType.BOAT);
        Transport.addTransports(transports, "/canoes.txt", TransportType.CANOE);
        Transport.addTransports(transports, "/charter_ships.txt", TransportType.CHARTER_SHIP);
        Transport.addTransports(transports, "/ships.txt", TransportType.SHIP);
        Transport.addTransports(transports, "/fairy_rings.txt", TransportType.FAIRY_RING);
        Transport.addTransports(transports, "/gnome_gliders.txt", TransportType.GNOME_GLIDER);
        Transport.addTransports(transports, "/spirit_trees.txt", TransportType.SPIRIT_TREE);
        Transport.addTransports(transports, "/levers.txt", TransportType.TELEPORTATION_LEVER);
        Transport.addTransports(transports, "/portals.txt", TransportType.TELEPORTATION_PORTAL);
        return transports;
    }

    public static List<WorldPoint> getFairyRings() {
        return fairyRings;
    }

    public static List<String> getFairyRingCodes() {
        return fairyRingCodes;
    }

    public WorldPoint getOrigin() {
        return this.origin;
    }

    public WorldPoint getDestination() {
        return this.destination;
    }

    public List<Quest> getQuests() {
        return this.quests;
    }

    public boolean isAgilityShortcut() {
        return this.isAgilityShortcut;
    }

    public boolean isGrappleShortcut() {
        return this.isGrappleShortcut;
    }

    public boolean isBoat() {
        return this.isBoat;
    }

    public boolean isCanoe() {
        return this.isCanoe;
    }

    public boolean isCharterShip() {
        return this.isCharterShip;
    }

    public boolean isShip() {
        return this.isShip;
    }

    public boolean isFairyRing() {
        return this.isFairyRing;
    }

    public boolean isGnomeGlider() {
        return this.isGnomeGlider;
    }

    public boolean isSpiritTree() {
        return this.isSpiritTree;
    }

    public boolean isTeleportationLever() {
        return this.isTeleportationLever;
    }

    public boolean isTeleportationPortal() {
        return this.isTeleportationPortal;
    }

    public int getWait() {
        return this.wait;
    }

    private static enum TransportType {
        TRANSPORT,
        AGILITY_SHORTCUT,
        BOAT,
        CANOE,
        CHARTER_SHIP,
        SHIP,
        FAIRY_RING,
        GNOME_GLIDER,
        SPIRIT_TREE,
        TELEPORTATION_LEVER,
        TELEPORTATION_PORTAL;

    }
}

