/*
 * Decompiled with CFR 0.152.
 */
package shortestpath;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import shortestpath.DebugOverlayPanel;
import shortestpath.PathMapOverlay;
import shortestpath.PathMapTooltipOverlay;
import shortestpath.PathMinimapOverlay;
import shortestpath.PathTileOverlay;
import shortestpath.ShortestPathConfig;
import shortestpath.Transport;
import shortestpath.pathfinder.CollisionMap;
import shortestpath.pathfinder.Pathfinder;
import shortestpath.pathfinder.PathfinderConfig;
import shortestpath.pathfinder.SplitFlagMap;

@PluginDescriptor(name="Shortest Path", description="Draws the shortest path to a chosen destination on the map (right click a spot on the world map to use)", tags={"pathfinder", "map", "waypoint", "navigation"})
public class ShortestPathPlugin
extends Plugin {
    protected static final String CONFIG_GROUP = "shortestpath";
    private static final String ADD_START = "Add start";
    private static final String ADD_END = "Add end";
    private static final String CLEAR = "Clear";
    private static final String PATH = ColorUtil.wrapWithColorTag((String)"Path", (Color)JagexColors.MENU_TARGET);
    private static final String SET = "Set";
    private static final String START = ColorUtil.wrapWithColorTag((String)"Start", (Color)JagexColors.MENU_TARGET);
    private static final String TARGET = ColorUtil.wrapWithColorTag((String)"Target", (Color)JagexColors.MENU_TARGET);
    private static final String TRANSPORT = ColorUtil.wrapWithColorTag((String)"Transport", (Color)JagexColors.MENU_TARGET);
    private static final String WALK_HERE = "Walk here";
    private static final BufferedImage MARKER_IMAGE = ImageUtil.loadImageResource(ShortestPathPlugin.class, (String)"/marker.png");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ShortestPathConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PathTileOverlay pathOverlay;
    @Inject
    private PathMinimapOverlay pathMinimapOverlay;
    @Inject
    private PathMapOverlay pathMapOverlay;
    @Inject
    private PathMapTooltipOverlay pathMapTooltipOverlay;
    @Inject
    private DebugOverlayPanel debugOverlayPanel;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private WorldMapOverlay worldMapOverlay;
    private Point lastMenuOpenedPoint;
    private WorldMapPoint marker;
    private WorldPoint transportStart;
    private WorldPoint lastLocation = new WorldPoint(0, 0, 0);
    private MenuEntry lastClick;
    private Shape minimapClipFixed;
    private Shape minimapClipResizeable;
    private BufferedImage minimapSpriteFixed;
    private BufferedImage minimapSpriteResizeable;
    private Rectangle minimapRectangle = new Rectangle();
    private ExecutorService pathfindingExecutor = Executors.newSingleThreadExecutor();
    private Future<?> pathfinderFuture;
    private final Object pathfinderMutex = new Object();
    private Pathfinder pathfinder;
    private PathfinderConfig pathfinderConfig;
    private boolean startPointSet = false;
    private final Pattern TRANSPORT_OPTIONS_REGEX = Pattern.compile("^(avoidWilderness|use\\w+)$");

    @Provides
    public ShortestPathConfig provideConfig(ConfigManager configManager) {
        return (ShortestPathConfig)configManager.getConfig(ShortestPathConfig.class);
    }

    protected void startUp() {
        SplitFlagMap map = SplitFlagMap.fromResources();
        HashMap<WorldPoint, List<Transport>> transports = Transport.loadAllFromResources();
        this.pathfinderConfig = new PathfinderConfig(map, transports, this.client, this.config);
        this.overlayManager.add((Overlay)this.pathOverlay);
        this.overlayManager.add((Overlay)this.pathMinimapOverlay);
        this.overlayManager.add((Overlay)this.pathMapOverlay);
        this.overlayManager.add((Overlay)this.pathMapTooltipOverlay);
        if (this.config.drawDebugPanel()) {
            this.overlayManager.add((Overlay)this.debugOverlayPanel);
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.pathOverlay);
        this.overlayManager.remove((Overlay)this.pathMinimapOverlay);
        this.overlayManager.remove((Overlay)this.pathMapOverlay);
        this.overlayManager.remove((Overlay)this.pathMapTooltipOverlay);
        this.overlayManager.remove((Overlay)this.debugOverlayPanel);
        if (this.pathfindingExecutor != null) {
            this.pathfindingExecutor.shutdownNow();
            this.pathfindingExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartPathfinding(WorldPoint start, WorldPoint end) {
        Object object = this.pathfinderMutex;
        synchronized (object) {
            if (this.pathfinder != null) {
                this.pathfinder.cancel();
                this.pathfinderFuture.cancel(true);
            }
            if (this.pathfindingExecutor == null) {
                ThreadFactory shortestPathNaming = new ThreadFactoryBuilder().setNameFormat("shortest-path-%d").build();
                this.pathfindingExecutor = Executors.newSingleThreadExecutor(shortestPathNaming);
            }
        }
        this.getClientThread().invokeLater(() -> {
            this.pathfinderConfig.refresh();
            Object object = this.pathfinderMutex;
            synchronized (object) {
                this.pathfinder = new Pathfinder(this.pathfinderConfig, start, end);
                this.pathfinderFuture = this.pathfindingExecutor.submit(this.pathfinder);
            }
        });
    }

    public boolean isNearPath(WorldPoint location) {
        if (this.pathfinder == null || this.pathfinder.getPath() == null || this.pathfinder.getPath().isEmpty() || this.config.recalculateDistance() < 0 || (this.lastLocation = location).equals((Object)this.lastLocation)) {
            return true;
        }
        for (WorldPoint point : this.pathfinder.getPath()) {
            if (location.distanceTo2D(point) >= this.config.recalculateDistance()) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        if ("drawDebugPanel".equals(event.getKey())) {
            if (this.config.drawDebugPanel()) {
                this.overlayManager.add((Overlay)this.debugOverlayPanel);
            } else {
                this.overlayManager.remove((Overlay)this.debugOverlayPanel);
            }
            return;
        }
        if (this.TRANSPORT_OPTIONS_REGEX.matcher(event.getKey()).find() && this.pathfinder != null) {
            this.restartPathfinding(this.pathfinder.getStart(), this.pathfinder.getTarget());
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        this.lastMenuOpenedPoint = this.client.getMouseCanvasPosition();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        WorldPoint currentLocation;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null || this.pathfinder == null) {
            return;
        }
        WorldPoint worldPoint = currentLocation = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
        if (currentLocation.distanceTo(this.pathfinder.getTarget()) < this.config.reachedDistance()) {
            this.setTarget(null);
            return;
        }
        if (!this.startPointSet && !this.isNearPath(currentLocation)) {
            if (this.config.cancelInstead()) {
                this.setTarget(null);
                return;
            }
            this.restartPathfinding(currentLocation, this.pathfinder.getTarget());
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Shape minimap;
        Widget map;
        if (this.client.isKeyPressed(81) && event.getOption().equals(WALK_HERE) && event.getTarget().isEmpty()) {
            if (this.config.drawTransports()) {
                this.addMenuEntry(event, ADD_START, TRANSPORT, 1);
                this.addMenuEntry(event, ADD_END, TRANSPORT, 1);
            }
            this.addMenuEntry(event, SET, TARGET, 1);
            if (this.pathfinder != null) {
                if (this.pathfinder.getTarget() != null) {
                    this.addMenuEntry(event, SET, START, 1);
                }
                WorldPoint selectedTile = this.getSelectedWorldPoint();
                if (this.pathfinder.getPath() != null) {
                    for (WorldPoint tile : this.pathfinder.getPath()) {
                        if (!tile.equals((Object)selectedTile)) continue;
                        this.addMenuEntry(event, CLEAR, PATH, 1);
                        break;
                    }
                }
            }
        }
        if ((map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW)) != null && map.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.addMenuEntry(event, SET, TARGET, 0);
            if (this.pathfinder != null && this.pathfinder.getTarget() != null) {
                this.addMenuEntry(event, SET, START, 0);
                this.addMenuEntry(event, CLEAR, PATH, 0);
            }
        }
        if ((minimap = this.getMinimapClipArea()) != null && this.pathfinder != null && minimap.contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.addMenuEntry(event, CLEAR, PATH, 0);
        }
        if (minimap != null && this.pathfinder != null && ("Floating World Map".equals(Text.removeTags((String)event.getOption())) || "Close Floating panel".equals(Text.removeTags((String)event.getOption())))) {
            this.addMenuEntry(event, CLEAR, PATH, 1);
        }
    }

    public Map<WorldPoint, List<Transport>> getTransports() {
        return this.pathfinderConfig.getTransports();
    }

    public CollisionMap getMap() {
        return this.pathfinderConfig.getMap();
    }

    private void onMenuOptionClicked(MenuEntry entry) {
        WorldPoint currentLocation;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return;
        }
        WorldPoint worldPoint = currentLocation = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
        if (entry.getOption().equals(ADD_START) && entry.getTarget().equals(TRANSPORT)) {
            this.transportStart = currentLocation;
        }
        if (entry.getOption().equals(ADD_END) && entry.getTarget().equals(TRANSPORT)) {
            WorldPoint transportEnd = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
            System.out.println(this.transportStart.getX() + " " + this.transportStart.getY() + " " + this.transportStart.getPlane() + " " + currentLocation.getX() + " " + currentLocation.getY() + " " + currentLocation.getPlane() + " " + this.lastClick.getOption() + " " + Text.removeTags((String)this.lastClick.getTarget()) + " " + this.lastClick.getIdentifier());
            Transport transport = new Transport(this.transportStart, transportEnd);
            this.pathfinderConfig.getTransports().computeIfAbsent(this.transportStart, k -> new ArrayList()).add(transport);
        }
        if (entry.getOption().equals("Copy Position")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("(" + currentLocation.getX() + ", " + currentLocation.getY() + ", " + currentLocation.getPlane() + ")"), null);
        }
        if (entry.getOption().equals(SET) && entry.getTarget().equals(TARGET)) {
            this.setTarget(this.getSelectedWorldPoint());
        }
        if (entry.getOption().equals(SET) && entry.getTarget().equals(START)) {
            this.setStart(this.getSelectedWorldPoint());
        }
        if (entry.getOption().equals(CLEAR) && entry.getTarget().equals(PATH)) {
            this.setTarget(null);
        }
        if (entry.getType() != MenuAction.WALK) {
            this.lastClick = entry;
        }
    }

    private WorldPoint getSelectedWorldPoint() {
        if (this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            if (this.client.getSelectedSceneTile() != null) {
                return this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation()) : this.client.getSelectedSceneTile().getWorldLocation();
            }
        } else {
            return this.calculateMapPoint(this.client.isMenuOpen() ? this.lastMenuOpenedPoint : this.client.getMouseCanvasPosition());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTarget(WorldPoint target) {
        Player localPlayer = this.client.getLocalPlayer();
        if (!this.startPointSet && localPlayer == null) {
            return;
        }
        if (target == null) {
            Object object = this.pathfinderMutex;
            synchronized (object) {
                if (this.pathfinder != null) {
                    this.pathfinder.cancel();
                }
                this.pathfinder = null;
            }
            this.worldMapPointManager.remove(this.marker);
            this.marker = null;
            this.startPointSet = false;
        } else {
            WorldPoint start;
            this.worldMapPointManager.removeIf(x -> x == this.marker);
            this.marker = new WorldMapPoint(target, MARKER_IMAGE);
            this.marker.setName("Target");
            this.marker.setTarget(this.marker.getWorldPoint());
            this.marker.setJumpOnClick(true);
            this.worldMapPointManager.add(this.marker);
            this.lastLocation = start = this.client.isInInstancedRegion() ? WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPlayer.getLocalLocation()) : localPlayer.getWorldLocation();
            if (this.startPointSet && this.pathfinder != null) {
                start = this.pathfinder.getStart();
            }
            this.restartPathfinding(start, target);
        }
    }

    private void setStart(WorldPoint start) {
        if (this.pathfinder == null) {
            return;
        }
        this.startPointSet = true;
        this.restartPathfinding(start, this.pathfinder.getTarget());
    }

    public WorldPoint calculateMapPoint(Point point) {
        WorldMap worldMap = this.client.getWorldMap();
        float zoom = worldMap.getWorldMapZoom();
        WorldPoint mapPoint = new WorldPoint(worldMap.getWorldMapPosition().getX(), worldMap.getWorldMapPosition().getY(), 0);
        Point middle = this.mapWorldPointToGraphicsPoint(mapPoint);
        if (point == null || middle == null) {
            return null;
        }
        int dx = (int)((float)(point.getX() - middle.getX()) / zoom);
        int dy = (int)((float)(-(point.getY() - middle.getY())) / zoom);
        return mapPoint.dx(dx).dy(dy);
    }

    public Point mapWorldPointToGraphicsPoint(WorldPoint worldPoint) {
        WorldMap worldMap = this.client.getWorldMap();
        float pixelsPerTile = worldMap.getWorldMapZoom();
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map != null) {
            Rectangle worldMapRect = map.getBounds();
            int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
            int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
            Point worldMapPosition = worldMap.getWorldMapPosition();
            int yTileMax = worldMapPosition.getY() - heightInTiles / 2;
            int yTileOffset = (yTileMax - worldPoint.getY() - 1) * -1;
            int xTileOffset = worldPoint.getX() + widthInTiles / 2 - worldMapPosition.getX();
            int xGraphDiff = (int)((float)xTileOffset * pixelsPerTile);
            int yGraphDiff = (int)((float)yTileOffset * pixelsPerTile);
            yGraphDiff = (int)((double)yGraphDiff - ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            xGraphDiff = (int)((double)xGraphDiff + ((double)pixelsPerTile - Math.ceil(pixelsPerTile / 2.0f)));
            yGraphDiff = worldMapRect.height - yGraphDiff;
            return new Point(xGraphDiff += (int)worldMapRect.getX(), yGraphDiff += (int)worldMapRect.getY());
        }
        return null;
    }

    private void addMenuEntry(MenuEntryAdded event, String option, String target, int position) {
        LinkedList<MenuEntry> entries = new LinkedList<MenuEntry>(Arrays.asList(this.client.getMenuEntries()));
        if (entries.stream().anyMatch(e -> e.getOption().equals(option) && e.getTarget().equals(target))) {
            return;
        }
        this.client.createMenuEntry(position).setOption(option).setTarget(target).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::onMenuOptionClicked);
    }

    private Widget getMinimapDrawWidget() {
        if (this.client.isResized()) {
            if (this.client.getVarbitValue(4607) == 1) {
                return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA);
            }
            return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA);
        }
        return this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
    }

    private Shape getMinimapClipAreaSimple() {
        Widget minimapDrawArea = this.getMinimapDrawWidget();
        if (minimapDrawArea == null || minimapDrawArea.isHidden()) {
            return null;
        }
        Rectangle bounds = minimapDrawArea.getBounds();
        return new Ellipse2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public Shape getMinimapClipArea() {
        Widget minimapWidget = this.getMinimapDrawWidget();
        if (minimapWidget == null || minimapWidget.isHidden() || !(this.minimapRectangle = minimapWidget.getBounds()).equals(this.minimapRectangle)) {
            this.minimapClipFixed = null;
            this.minimapClipResizeable = null;
            this.minimapSpriteFixed = null;
            this.minimapSpriteResizeable = null;
        }
        if (this.client.isResized()) {
            if (this.minimapClipResizeable != null) {
                return this.minimapClipResizeable;
            }
            if (this.minimapSpriteResizeable == null) {
                this.minimapSpriteResizeable = this.spriteManager.getSprite(1178, 0);
            }
            if (this.minimapSpriteResizeable != null) {
                this.minimapClipResizeable = this.bufferedImageToPolygon(this.minimapSpriteResizeable);
                return this.minimapClipResizeable;
            }
            return this.getMinimapClipAreaSimple();
        }
        if (this.minimapClipFixed != null) {
            return this.minimapClipFixed;
        }
        if (this.minimapSpriteFixed == null) {
            this.minimapSpriteFixed = this.spriteManager.getSprite(1183, 0);
        }
        if (this.minimapSpriteFixed != null) {
            this.minimapClipFixed = this.bufferedImageToPolygon(this.minimapSpriteFixed);
            return this.minimapClipFixed;
        }
        return this.getMinimapClipAreaSimple();
    }

    private Polygon bufferedImageToPolygon(BufferedImage image) {
        Color outsideColour = null;
        int width = image.getWidth();
        int height = image.getHeight();
        ArrayList<java.awt.Point> points = new ArrayList<java.awt.Point>();
        for (int y = 0; y < height; ++y) {
            Color previousColour = outsideColour;
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                int a = (rgb & 0xFF000000) >>> 24;
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = (rgb & 0xFF) >> 0;
                Color colour = new Color(r, g, b, a);
                if (x == 0 && y == 0) {
                    outsideColour = colour;
                    previousColour = colour;
                }
                if (!colour.equals(outsideColour) && previousColour.equals(outsideColour)) {
                    points.add(new java.awt.Point(x, y));
                }
                if ((colour.equals(outsideColour) || x == width - 1) && !previousColour.equals(outsideColour)) {
                    points.add(0, new java.awt.Point(x, y));
                }
                previousColour = colour;
            }
        }
        int offsetX = this.minimapRectangle.x;
        int offsetY = this.minimapRectangle.y;
        Polygon polygon = new Polygon();
        for (java.awt.Point point : points) {
            polygon.addPoint(point.x + offsetX, point.y + offsetY);
        }
        return polygon;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public Pathfinder getPathfinder() {
        return this.pathfinder;
    }

    public boolean isStartPointSet() {
        return this.startPointSet;
    }
}

