/*
 * Decompiled with CFR 0.152.
 */
package shortestpath;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;
import shortestpath.TileCounter;
import shortestpath.TileStyle;

@ConfigGroup(value="shortestpath")
public interface ShortestPathConfig
extends Config {
    @ConfigSection(name="Settings", description="Options for the pathfinding", position=0)
    public static final String sectionSettings = "sectionSettings";
    @ConfigSection(name="Display", description="Options for displaying the path on the world map, minimap and scene tiles", position=19)
    public static final String sectionDisplay = "sectionDisplay";
    @ConfigSection(name="Colours", description="Colours for the path map, minimap and scene tiles", position=24)
    public static final String sectionColours = "sectionColours";
    @ConfigSection(name="Debug Options", description="Various options for debugging", position=30, closedByDefault=true)
    public static final String sectionDebug = "sectionDebug";

    @ConfigItem(keyName="avoidWilderness", name="Avoid wilderness", description="Whether the wilderness should be avoided if possible<br>(otherwise, will e.g. suggest using wilderness lever to travel from Edgeville to Ardougne)", position=1, section="sectionSettings")
    default public boolean avoidWilderness() {
        return true;
    }

    @ConfigItem(keyName="useAgilityShortcuts", name="Use agility shortcuts", description="Whether to include agility shortcuts in the path.<br>You must also have the required agility level", position=2, section="sectionSettings")
    default public boolean useAgilityShortcuts() {
        return true;
    }

    @ConfigItem(keyName="useGrappleShortcuts", name="Use grapple shortcuts", description="Whether to include crossbow grapple agility shortcuts in the path.<br>You must also have the required agility, ranged and strength levels", position=3, section="sectionSettings")
    default public boolean useGrappleShortcuts() {
        return false;
    }

    @ConfigItem(keyName="useBoats", name="Use boats", description="Whether to include small boats in the path<br>(e.g. the boat to Fishing Platform)", position=4, section="sectionSettings")
    default public boolean useBoats() {
        return true;
    }

    @ConfigItem(keyName="useCanoes", name="Use canoes", description="Whether to include canoes in the path", position=5, section="sectionSettings")
    default public boolean useCanoes() {
        return false;
    }

    @ConfigItem(keyName="useCharterShips", name="Use charter ships", description="Whether to include charter ships in the path", position=6, section="sectionSettings")
    default public boolean useCharterShips() {
        return false;
    }

    @ConfigItem(keyName="useShips", name="Use ships", description="Whether to include passenger ships in the path<br>(e.g. the customs ships to Karamja)", position=7, section="sectionSettings")
    default public boolean useShips() {
        return true;
    }

    @ConfigItem(keyName="useFairyRings", name="Use fairy rings", description="Whether to include fairy rings in the path.<br>You must also have completed the required quests or miniquests", position=8, section="sectionSettings")
    default public boolean useFairyRings() {
        return true;
    }

    @ConfigItem(keyName="useGnomeGliders", name="Use gnome gliders", description="Whether to include gnome gliders in the path", position=9, section="sectionSettings")
    default public boolean useGnomeGliders() {
        return true;
    }

    @ConfigItem(keyName="useSpiritTrees", name="Use spirit trees", description="Whether to include spirit trees in the path", position=10, section="sectionSettings")
    default public boolean useSpiritTrees() {
        return true;
    }

    @ConfigItem(keyName="useTeleportationLevers", name="Use teleportation levers", description="Whether to include teleportation levers in the path<br>(e.g. the lever from Edgeville to Wilderness)", position=11, section="sectionSettings")
    default public boolean useTeleportationLevers() {
        return true;
    }

    @ConfigItem(keyName="useTeleportationPortals", name="Use teleportation portals", description="Whether to include teleportation portals in the path<br>(e.g. the portal from Ferox Enclave to Castle Wars)", position=12, section="sectionSettings")
    default public boolean useTeleportationPortals() {
        return true;
    }

    @ConfigItem(keyName="cancelInstead", name="Cancel instead of recalculating", description="Whether the path should be cancelled rather than recalculated when the recalculate distance limit is exceeded", position=13, section="sectionSettings")
    default public boolean cancelInstead() {
        return false;
    }

    @Range(min=-1, max=20000)
    @ConfigItem(keyName="recalculateDistance", name="Recalculate distance", description="Distance from the path the player should be for it to be recalculated (-1 for never)", position=14, section="sectionSettings")
    default public int recalculateDistance() {
        return 10;
    }

    @Range(min=-1, max=50)
    @ConfigItem(keyName="finishDistance", name="Finish distance", description="Distance from the target tile at which the path should be ended (-1 for never)", position=15, section="sectionSettings")
    default public int reachedDistance() {
        return 5;
    }

    @ConfigItem(keyName="showTileCounter", name="Show tile counter", description="Whether to display the number of tiles travelled, number of tiles remaining or disable counting", position=16, section="sectionSettings")
    default public TileCounter showTileCounter() {
        return TileCounter.DISABLED;
    }

    @ConfigItem(keyName="tileCounterStep", name="Tile counter step", description="The number of tiles between the displayed tile counter numbers", position=17, section="sectionSettings")
    default public int tileCounterStep() {
        return 1;
    }

    @Units(value=" ticks")
    @Range(min=1, max=30)
    @ConfigItem(keyName="calculationCutoff", name="Calculation cutoff", description="The cutoff threshold in number of ticks (0.6 seconds) of no progress being<br>made towards the path target before the calculation will be stopped", position=18, section="sectionSettings")
    default public int calculationCutoff() {
        return 5;
    }

    @ConfigItem(keyName="drawMap", name="Draw path on world map", description="Whether the path should be drawn on the world map", position=20, section="sectionDisplay")
    default public boolean drawMap() {
        return true;
    }

    @ConfigItem(keyName="drawMinimap", name="Draw path on minimap", description="Whether the path should be drawn on the minimap", position=21, section="sectionDisplay")
    default public boolean drawMinimap() {
        return true;
    }

    @ConfigItem(keyName="drawTiles", name="Draw path on tiles", description="Whether the path should be drawn on the game tiles", position=22, section="sectionDisplay")
    default public boolean drawTiles() {
        return true;
    }

    @ConfigItem(keyName="pathStyle", name="Path style", description="Whether to display the path as tiles or a segmented line", position=23, section="sectionDisplay")
    default public TileStyle pathStyle() {
        return TileStyle.TILES;
    }

    @Alpha
    @ConfigItem(keyName="colourPath", name="Path", description="Colour of the path tiles on the world map, minimap and in the game scene", position=25, section="sectionColours")
    default public Color colourPath() {
        return new Color(255, 0, 0);
    }

    @Alpha
    @ConfigItem(keyName="colourPathCalculating", name="Calculating", description="Colour of the path tiles while the pathfinding calculation is in progress", position=26, section="sectionColours")
    default public Color colourPathCalculating() {
        return new Color(0, 0, 255);
    }

    @Alpha
    @ConfigItem(keyName="colourTransports", name="Transports", description="Colour of the transport tiles", position=27, section="sectionColours")
    default public Color colourTransports() {
        return new Color(0, 255, 0, 128);
    }

    @Alpha
    @ConfigItem(keyName="colourCollisionMap", name="Collision map", description="Colour of the collision map tiles", position=28, section="sectionColours")
    default public Color colourCollisionMap() {
        return new Color(0, 128, 255, 128);
    }

    @Alpha
    @ConfigItem(keyName="colourText", name="Text", description="Colour of the text of the tile counter and fairy ring codes", position=29, section="sectionColours")
    default public Color colourText() {
        return Color.WHITE;
    }

    @ConfigItem(keyName="drawTransports", name="Draw transports", description="Whether transports should be drawn", position=31, section="sectionDebug")
    default public boolean drawTransports() {
        return false;
    }

    @ConfigItem(keyName="drawCollisionMap", name="Draw collision map", description="Whether the collision map should be drawn", position=32, section="sectionDebug")
    default public boolean drawCollisionMap() {
        return false;
    }

    @ConfigItem(keyName="drawDebugPanel", name="Show debug panel", description="Toggles displaying the pathfinding debug stats panel", position=33, section="sectionDebug")
    default public boolean drawDebugPanel() {
        return false;
    }
}

