/*
 * Decompiled with CFR 0.152.
 */
package shortestpath;

import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import shortestpath.ShortestPathConfig;
import shortestpath.ShortestPathPlugin;

public class PathMapTooltipOverlay
extends Overlay {
    private static final int TOOLTIP_OFFSET_HEIGHT = 25;
    private static final int TOOLTIP_OFFSET_WIDTH = 15;
    private static final int TOOLTIP_PADDING_HEIGHT = 1;
    private static final int TOOLTIP_PADDING_WIDTH = 2;
    private static final int TOOLTIP_TEXT_OFFSET_HEIGHT = -2;
    private final Client client;
    private final ShortestPathPlugin plugin;
    private final ShortestPathConfig config;

    @Inject
    private PathMapTooltipOverlay(Client client, ShortestPathPlugin plugin, ShortestPathConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterInterface(595);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.drawMap() || this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW) == null) {
            return null;
        }
        if (this.plugin.getPathfinder() != null) {
            List<WorldPoint> path = this.plugin.getPathfinder().getPath();
            Point cursorPos = this.client.getMouseCanvasPosition();
            for (int i = 0; i < path.size(); ++i) {
                if (!this.drawTooltip(graphics, cursorPos, path.get(i), i + 1)) continue;
                return null;
            }
        }
        return null;
    }

    private boolean drawTooltip(Graphics2D graphics, Point cursorPos, WorldPoint point, int n) {
        Point start = this.plugin.mapWorldPointToGraphicsPoint(point);
        Point end = this.plugin.mapWorldPointToGraphicsPoint(point.dx(1).dy(-1));
        if (start == null || end == null) {
            return false;
        }
        int width = end.getX() - start.getX();
        if (cursorPos.getX() < start.getX() - width / 2 || cursorPos.getX() > end.getX() - width / 2 || cursorPos.getY() < start.getY() - width / 2 || cursorPos.getY() > end.getY() - width / 2) {
            return false;
        }
        List<String> rows = Arrays.asList("Shortest path:", "Step " + n + " of " + this.plugin.getPathfinder().getPath().size());
        graphics.setFont(FontManager.getRunescapeFont());
        FontMetrics fm = graphics.getFontMetrics();
        int tooltipHeight = fm.getHeight();
        int tooltipWidth = rows.stream().map(fm::stringWidth).max(Integer::compareTo).get();
        int clippedHeight = tooltipHeight + 2;
        int clippedWidth = tooltipWidth + 4;
        Rectangle worldMapBounds = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW).getBounds();
        int worldMapRightBoundary = worldMapBounds.width + worldMapBounds.x;
        int worldMapBottomBoundary = worldMapBounds.height + worldMapBounds.y;
        int drawPointX = start.getX() + 15;
        int drawPointY = start.getY();
        if (drawPointX + clippedWidth > worldMapRightBoundary) {
            drawPointX = worldMapRightBoundary - clippedWidth;
        }
        if (drawPointY + clippedHeight > worldMapBottomBoundary) {
            drawPointY = start.getY() - 50 - tooltipHeight;
        }
        Rectangle tooltipRect = new Rectangle(drawPointX - 2, (drawPointY += 25) - 1, tooltipWidth + 4, tooltipHeight * rows.size() + 2);
        graphics.setColor(JagexColors.TOOLTIP_BACKGROUND);
        graphics.fillRect(tooltipRect.x, tooltipRect.y, tooltipRect.width, tooltipRect.height);
        graphics.setColor(JagexColors.TOOLTIP_BORDER);
        graphics.drawRect(tooltipRect.x, tooltipRect.y, tooltipRect.width, tooltipRect.height);
        graphics.setColor(JagexColors.TOOLTIP_TEXT);
        for (int i = 0; i < rows.size(); ++i) {
            graphics.drawString(rows.get(i), drawPointX, drawPointY + -2 + (i + 1) * tooltipHeight);
        }
        return true;
    }
}

