/*
 * Decompiled with CFR 0.152.
 */
package shortestpath;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import shortestpath.ShortestPathPlugin;
import shortestpath.pathfinder.Pathfinder;

public class DebugOverlayPanel
extends OverlayPanel {
    private final ShortestPathPlugin plugin;
    private final SeparatorLine separator;

    @Inject
    public DebugOverlayPanel(ShortestPathPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.separator = new SeparatorLine();
        this.separator.setColor(new Color(0, true));
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    private LineComponent makeLine(String left, String right) {
        return LineComponent.builder().left(left).right(right).build();
    }

    public Dimension render(Graphics2D graphics) {
        Pathfinder.PathfinderStats stats;
        Pathfinder pathfinder = this.plugin.getPathfinder();
        if (pathfinder == null || (stats = pathfinder.getStats()) == null) {
            return null;
        }
        List components = this.panelComponent.getChildren();
        components.add(TitleComponent.builder().text("Shortest Path Debug").color(Color.ORANGE).build());
        components.add(this.separator);
        String pathLength = Integer.toString(pathfinder.getPath().size());
        components.add(this.makeLine("Path Length:", pathLength));
        components.add(this.separator);
        String nodes = Integer.toString(stats.getNodesChecked());
        components.add(this.makeLine("Nodes:", nodes));
        String transports = Integer.toString(stats.getTransportsChecked());
        components.add(this.makeLine("Transports:", transports));
        String totalNodes = Integer.toString(stats.getTotalNodesChecked());
        components.add(this.makeLine("Total:", totalNodes));
        components.add(this.separator);
        double milliTime = (double)stats.getElapsedTimeNanos() / 1000000.0;
        String time = String.format("%.2fms", milliTime);
        components.add(this.makeLine("Time:", time));
        return super.render(graphics);
    }

    private static class SeparatorLine
    implements LayoutableRenderableEntity {
        private Color color = Color.GRAY;
        private Point preferredLocation = new Point();
        private Dimension preferredSize = new Dimension(129, 4);
        private final Rectangle bounds = new Rectangle();

        private SeparatorLine() {
        }

        public Dimension render(Graphics2D graphics) {
            int separatorX = this.preferredLocation.x;
            int separatorY = this.preferredLocation.y + 4;
            int width = this.preferredSize.width;
            int height = Math.max(this.preferredSize.height, 2);
            if (this.color != null && this.color.getAlpha() != 0) {
                graphics.setColor(this.color);
                graphics.fillRect(separatorX, separatorY, width, height);
            }
            Dimension dimension = new Dimension(width, height + 4);
            this.bounds.setLocation(this.preferredLocation);
            this.bounds.setSize(dimension);
            return dimension;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setPreferredLocation(Point preferredLocation) {
            this.preferredLocation = preferredLocation;
        }

        public void setPreferredSize(Dimension preferredSize) {
            this.preferredSize = preferredSize;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

