/*
 * Decompiled with CFR 0.152.
 */
package sky.clueSteps;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import sky.clueSteps.ClueStepType;

enum ClueWithStep {

    private final ClueStepType type;
    private final int id;
    private final int charges;
    private static final Map<Integer, ClueWithStep> ID_MAP;

    @Nullable
    static ClueWithStep findItem(int itemId) {
        return ID_MAP.get(itemId);
    }

    private ClueWithStep(ClueStepType type, int id, int charges) {
        this.type = type;
        this.id = id;
        this.charges = charges;
    }

    public ClueStepType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public int getCharges() {
        return this.charges;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ClueWithStep clueStep : ClueWithStep.values()) {
            builder.put((Object)clueStep.getId(), (Object)clueStep);
        }
        ID_MAP = builder.build();
    }
}

