/*
 * Decompiled with CFR 0.152.
 */
package sky.clueSteps;

import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sky.clueSteps.ClueStepConfig;
import sky.clueSteps.ClueStepOverlay;
import sky.clueSteps.ClueWithConfig;

@PluginDescriptor(name="Clue Steps", description="Show number of steps done on each clue", tags={"inventory", "clues", "overlay"})
public class ClueStepPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClueStepPlugin.class);
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClueStepOverlay overlay;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    private static final Pattern BEGINNER_PATTERN = Pattern.compile("You have completed (\\d+) steps? on this beginner clue scroll\\.");
    private static final Pattern EASY_PATTERN = Pattern.compile("You have completed (\\d+) steps? on this easy clue scroll\\.");
    private static final Pattern MEDIUM_PATTERN = Pattern.compile("You have completed (\\d+) steps? on this medium clue scroll\\.");
    private static final Pattern HARD_PATTERN = Pattern.compile("You have completed (\\d+) steps? on this hard clue scroll\\.");
    private static final Pattern ELITE_PATTERN = Pattern.compile("You have completed (\\d+) steps? on this elite clue scroll\\.");
    private static final Pattern MASTER_PATTERN = Pattern.compile("You have completed (\\d+) steps? on this master clue scroll\\.");
    private boolean loginFlag;
    private static final int WATSON_HAS_EASY_VARBIT = 5186;
    private static final int WATSON_HAS_MEDIUM_VARBIT = 5187;
    private static final int WATSON_HAS_HARD_VARBIT = 5188;
    private static final int WATSON_HAS_ELITE_VARBIT = 5189;
    private boolean watsonHasEasy;
    private boolean watsonHasMedium;
    private boolean watsonHasHard;
    private boolean watsonHasElite;

    @Provides
    ClueStepConfig getConfig(ConfigManager configManager) {
        return (ClueStepConfig)configManager.getConfig(ClueStepConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.loginFlag = true;
        }
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.loginFlag = true;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.loginFlag) {
            this.updateWatson();
            this.loginFlag = false;
        }
    }

    private void updateWatson() {
        block6: for (ClueTier tier : ClueTier.values()) {
            boolean hasClue = this.watsonHasClue(tier);
            switch (tier) {
                case EASY: {
                    this.watsonHasEasy = hasClue;
                    continue block6;
                }
                case MEDIUM: {
                    this.watsonHasMedium = hasClue;
                    continue block6;
                }
                case HARD: {
                    this.watsonHasHard = hasClue;
                    continue block6;
                }
                case ELITE: {
                    this.watsonHasElite = hasClue;
                }
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE || event.getType() == ChatMessageType.SPAM) {
            String message = Text.removeTags((String)event.getMessage());
            Matcher beginnerMatcher = BEGINNER_PATTERN.matcher(message);
            Matcher easyMatcher = EASY_PATTERN.matcher(message);
            Matcher mediumMatcher = MEDIUM_PATTERN.matcher(message);
            Matcher hardMatcher = HARD_PATTERN.matcher(message);
            Matcher eliteMatcher = ELITE_PATTERN.matcher(message);
            Matcher masterMatcher = MASTER_PATTERN.matcher(message);
            if (beginnerMatcher.find()) {
                this.updateBeginner(Integer.parseInt(beginnerMatcher.group(1)));
            } else if (easyMatcher.find()) {
                this.updateEasy(Integer.parseInt(easyMatcher.group(1)));
            } else if (mediumMatcher.find()) {
                this.updateMedium(Integer.parseInt(mediumMatcher.group(1)));
            } else if (hardMatcher.find()) {
                this.updateHard(Integer.parseInt(hardMatcher.group(1)));
            } else if (eliteMatcher.find()) {
                this.updateElite(Integer.parseInt(eliteMatcher.group(1)));
            } else if (masterMatcher.find()) {
                this.updateMaster(Integer.parseInt(masterMatcher.group(1)));
            }
        }
    }

    private void updateBeginner(int value) {
        this.setClueSteps("clueBeginner", value);
    }

    private void updateEasy(int value) {
        this.setClueSteps("clueEasy", value);
    }

    private void updateEasy(int value, int ID) {
        this.setClueSteps("clueEasy", value);
        this.setClueSteps("idEasy", ID);
    }

    private void updateMedium(int value) {
        this.setClueSteps("clueMedium", value);
    }

    private void updateMedium(int value, int ID) {
        this.setClueSteps("clueMedium", value);
        this.setClueSteps("idMedium", ID);
    }

    private void updateHard(int value) {
        this.setClueSteps("clueHard", value);
    }

    private void updateHard(int value, int ID) {
        this.setClueSteps("clueHard", value);
        this.setClueSteps("idHard", ID);
    }

    private void updateElite(int value) {
        this.setClueSteps("clueElite", value);
    }

    private void updateElite(int value, int ID) {
        this.setClueSteps("clueElite", value);
        this.setClueSteps("idElite", ID);
    }

    private void updateMaster(int value) {
        this.setClueSteps("clueMaster", value);
    }

    int getClueSteps(String key) {
        Integer i = (Integer)this.configManager.getRSProfileConfiguration("clueSteps", key, Integer.class);
        return i == null ? -1 : i;
    }

    private void setClueSteps(String key, int value) {
        this.configManager.setRSProfileConfiguration("clueSteps", key, (Object)value);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 193) {
            this.clientThread.invokeLater(() -> {
                Widget sprite = this.client.getWidget(WidgetInfo.DIALOG_SPRITE_SPRITE);
                int clueID = sprite.getItemId();
                switch (clueID) {
                    case 23245: {
                        this.updateBeginner(0);
                        return;
                    }
                    case 20546: {
                        this.updateEasy(-1, 0);
                        return;
                    }
                    case 20545: {
                        this.updateMedium(-1, 0);
                        return;
                    }
                    case 20544: {
                        this.updateHard(-1, 0);
                        return;
                    }
                    case 20543: {
                        this.updateElite(-1, 0);
                        return;
                    }
                    case 19836: {
                        this.updateMaster(0);
                        return;
                    }
                }
                ClueWithConfig clueType = ClueWithConfig.findItem(clueID);
                if (clueType == null) {
                    return;
                }
                int steps = this.getClueSteps(clueType.getConfigKey()) + 1;
                switch (clueType.getType()) {
                    case BEGINNER_CLUE: {
                        this.updateBeginner(steps);
                        return;
                    }
                    case MASTER_CLUE: {
                        this.updateMaster(steps);
                        return;
                    }
                }
            });
        }
    }

    private ArrayList<WatsonChanged> WatsonChanged() {
        boolean[] watsonState = new boolean[]{this.watsonHasEasy, this.watsonHasMedium, this.watsonHasHard, this.watsonHasElite};
        this.updateWatson();
        boolean[] updated = new boolean[]{this.watsonHasEasy, this.watsonHasMedium, this.watsonHasHard, this.watsonHasElite};
        ArrayList<WatsonChanged> changed = new ArrayList<WatsonChanged>();
        for (int i = 0; i < watsonState.length; ++i) {
            if (watsonState[i] == updated[i]) continue;
            changed.add(new WatsonChanged(ClueTier.values()[i], updated[i]));
        }
        return changed;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (this.loginFlag || event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        Item[] invItems = event.getItemContainer().getItems();
        ArrayList<WatsonChanged> watson = this.WatsonChanged();
        if (watson.size() > 0) {
            if (!(this.watsonHasEasy || this.watsonHasMedium || this.watsonHasHard || this.watsonHasElite)) {
                this.updateMaster(-1);
            }
            for (WatsonChanged w : watson) {
                if (!w.givenToWatson) continue;
                switch (w.tier) {
                    case EASY: {
                        this.updateEasy(-1, 0);
                        break;
                    }
                    case MEDIUM: {
                        this.updateMedium(-1, 0);
                        break;
                    }
                    case HARD: {
                        this.updateHard(-1, 0);
                        break;
                    }
                    case ELITE: {
                        this.updateElite(-1, 0);
                    }
                }
            }
        } else {
            block13: for (Item item : invItems) {
                ClueWithConfig clue = ClueWithConfig.findItem(item.getId());
                if (clue == null) continue;
                int clueID = item.getId();
                int steps = this.getClueSteps(clue.getConfigKey()) + 1;
                switch (clue.getType()) {
                    case EASY_CLUE: {
                        if (this.getClueSteps("idEasy") == clueID) continue block13;
                        this.updateEasy(steps, clueID);
                        continue block13;
                    }
                    case MEDIUM_CLUE: {
                        if (this.getClueSteps("idMedium") == clueID) continue block13;
                        this.updateMedium(steps, clueID);
                        continue block13;
                    }
                    case HARD_CLUE: {
                        if (this.getClueSteps("idHard") == clueID) continue block13;
                        this.updateHard(steps, clueID);
                        continue block13;
                    }
                    case ELITE_CLUE: {
                        if (this.getClueSteps("idElite") == clueID) continue block13;
                        this.updateElite(steps, clueID);
                        continue block13;
                    }
                }
            }
        }
    }

    public boolean watsonHasClue(ClueTier tier) {
        if (tier == ClueTier.EASY) {
            return this.client.getVarbitValue(5186) == 1;
        }
        if (tier == ClueTier.MEDIUM) {
            return this.client.getVarbitValue(5187) == 1;
        }
        if (tier == ClueTier.HARD) {
            return this.client.getVarbitValue(5188) == 1;
        }
        if (tier == ClueTier.ELITE) {
            return this.client.getVarbitValue(5189) == 1;
        }
        return false;
    }

    static class WatsonChanged {
        private final ClueTier tier;
        private final boolean givenToWatson;

        private WatsonChanged(ClueTier tier, boolean givenToWatson) {
            this.tier = tier;
            this.givenToWatson = givenToWatson;
        }

        public static WatsonChanged of(ClueTier tier, boolean givenToWatson) {
            return new WatsonChanged(tier, givenToWatson);
        }

        public ClueTier getTier() {
            return this.tier;
        }

        public boolean isGivenToWatson() {
            return this.givenToWatson;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WatsonChanged)) {
                return false;
            }
            WatsonChanged other = (WatsonChanged)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGivenToWatson() != other.isGivenToWatson()) {
                return false;
            }
            ClueTier this$tier = this.getTier();
            ClueTier other$tier = other.getTier();
            return !(this$tier == null ? other$tier != null : !((Object)((Object)this$tier)).equals((Object)other$tier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WatsonChanged;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGivenToWatson() ? 79 : 97);
            ClueTier $tier = this.getTier();
            result = result * 59 + ($tier == null ? 43 : ((Object)((Object)$tier)).hashCode());
            return result;
        }

        public String toString() {
            return "ClueStepPlugin.WatsonChanged(tier=" + this.getTier() + ", givenToWatson=" + this.isGivenToWatson() + ")";
        }
    }

    static enum ClueTier {
        EASY,
        MEDIUM,
        HARD,
        ELITE;

    }
}

