/*
 * Decompiled with CFR 0.152.
 */
package sky.clueSteps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;
import sky.clueSteps.ClueStepConfig;
import sky.clueSteps.ClueStepPlugin;
import sky.clueSteps.ClueStepType;
import sky.clueSteps.ClueWithConfig;
import sky.clueSteps.ClueWithStep;

class ClueStepOverlay
extends WidgetItemOverlay {
    private final ClueStepPlugin clueStepPlugin;
    private final ClueStepConfig config;
    private final Color NORMAL = Color.WHITE;

    @Inject
    ClueStepOverlay(ClueStepPlugin clueStepPlugin, ClueStepConfig config) {
        this.clueStepPlugin = clueStepPlugin;
        this.config = config;
        this.showOnInventory();
        this.showOnEquipment();
    }

    public ClueStepConfig.ClueRange GetStepRange(ClueStepType type) {
        switch (type) {
            case BEGINNER_CLUE: {
                return ClueStepConfig.STEPS_BEGINNER;
            }
            case EASY_CLUE: {
                return ClueStepConfig.STEPS_EASY;
            }
            case MEDIUM_CLUE: {
                return ClueStepConfig.STEPS_MEDIUM;
            }
            case HARD_CLUE: {
                return ClueStepConfig.STEPS_HARD;
            }
            case ELITE_CLUE: {
                return ClueStepConfig.STEPS_ELITE;
            }
            case MASTER_CLUE: {
                return ClueStepConfig.STEPS_MASTER;
            }
        }
        return null;
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        int steps;
        ClueStepType type;
        ClueWithConfig clueWithConfig = ClueWithConfig.findItem(itemId);
        if (clueWithConfig != null) {
            type = clueWithConfig.getType();
            if (!type.getEnabled().test(this.config)) {
                return;
            }
            steps = this.clueStepPlugin.getClueSteps(clueWithConfig.getConfigKey());
        } else {
            ClueWithStep clue = ClueWithStep.findItem(itemId);
            if (clue == null) {
                return;
            }
            type = clue.getType();
            if (!type.getEnabled().test(this.config)) {
                return;
            }
            steps = clue.getCharges();
        }
        graphics.setFont(FontManager.getRunescapeSmallFont());
        Rectangle bounds = widgetItem.getCanvasBounds();
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y + 15));
        textComponent.setText(steps < 0 ? "?" : String.valueOf(steps));
        textComponent.setColor(this.GetColor(steps, type));
        textComponent.render(graphics);
    }

    private Color GetColor(int steps, ClueStepType type) {
        if (!this.config.recolor()) {
            return this.NORMAL;
        }
        int maxSteps = this.GetStepRange(type).getMax();
        switch (maxSteps - steps) {
            case 1: {
                return this.config.getColorGuaranteed();
            }
            case 2: {
                return this.config.getColorProbably();
            }
            case 3: {
                return this.config.getColorPossibly();
            }
        }
        return this.NORMAL;
    }
}

