/*
 * Decompiled with CFR 0.152.
 */
package sky.clueSteps;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="clueSteps")
public interface ClueStepConfig
extends Config {
    public static final String GROUP = "clueSteps";
    public static final String KEY_BEGINNER = "clueBeginner";
    public static final String KEY_EASY = "clueEasy";
    public static final String KEY_MEDIUM = "clueMedium";
    public static final String KEY_HARD = "clueHard";
    public static final String KEY_ELITE = "clueElite";
    public static final String KEY_MASTER = "clueMaster";
    public static final String ID_EASY = "idEasy";
    public static final String ID_MEDIUM = "idMedium";
    public static final String ID_HARD = "idHard";
    public static final String ID_ELITE = "idElite";
    public static final ClueRange STEPS_BEGINNER = new ClueRange(1, 3);
    public static final ClueRange STEPS_EASY = new ClueRange(2, 4);
    public static final ClueRange STEPS_MEDIUM = new ClueRange(3, 5);
    public static final ClueRange STEPS_HARD = new ClueRange(4, 6);
    public static final ClueRange STEPS_ELITE = new ClueRange(5, 7);
    public static final ClueRange STEPS_MASTER = new ClueRange(6, 8);

    @ConfigItem(keyName="trackBeginner", name="Track beginner", description="Show steps completed on beginner clues.", position=1)
    default public boolean trackBeginner() {
        return true;
    }

    @ConfigItem(keyName="trackEasy", name="Track easy", description="Show steps completed on easy clues.", position=2)
    default public boolean trackEasy() {
        return true;
    }

    @ConfigItem(keyName="trackMedium", name="Track medium", description="Show steps completed on medium clues.", position=3)
    default public boolean trackMedium() {
        return true;
    }

    @ConfigItem(keyName="trackHard", name="Track hard", description="Show steps completed on hard clues.", position=4)
    default public boolean trackHard() {
        return true;
    }

    @ConfigItem(keyName="trackElite", name="Track elite", description="Show steps completed on elite clues.", position=5)
    default public boolean trackElite() {
        return true;
    }

    @ConfigItem(keyName="trackMaster", name="Track master", description="Show steps completed on master clues.", position=6)
    default public boolean trackMaster() {
        return true;
    }

    @ConfigItem(keyName="recolor", name="Recolor step counter", description="Recolors the step counter when the clue can be completed.", position=7)
    default public boolean recolor() {
        return true;
    }

    @Alpha
    @ConfigItem(position=8, keyName="ColorPossibly", name="Color Possibly", description="Color when next step possibly results in a casket")
    default public Color getColorPossibly() {
        return Color.ORANGE;
    }

    @Alpha
    @ConfigItem(position=9, keyName="ColorProbably", name="Color Probably", description="Color when next step probably results in a casket")
    default public Color getColorProbably() {
        return Color.YELLOW;
    }

    @Alpha
    @ConfigItem(position=10, keyName="ColorGuaranteed", name="Color Guaranteed", description="Color when next step is a guaranteed casket")
    default public Color getColorGuaranteed() {
        return Color.GREEN;
    }

    public static class ClueRange {
        private final Integer min;
        private final Integer max;

        private ClueRange(Integer min, Integer max) {
            this.min = min;
            this.max = max;
        }

        public static ClueRange of(Integer min, Integer max) {
            return new ClueRange(min, max);
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClueRange)) {
                return false;
            }
            ClueRange other = (ClueRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$min = this.getMin();
            Integer other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            Integer this$max = this.getMax();
            Integer other$max = other.getMax();
            return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClueRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            Integer $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            return result;
        }

        public String toString() {
            return "ClueStepConfig.ClueRange(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }
}

