/*
 * Decompiled with CFR 0.152.
 */
package xrio.npcid;

import com.google.inject.Inject;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import xrio.npcid.NpcIdConfig;
import xrio.npcid.NpcIdOverlay;

@PluginDescriptor(name="NPC ID", description="Display identification information as text above NPCs.", tags={"NPC", "ID", "index", "name"})
public class NpcIdPlugin
extends Plugin {
    private static final Set<Integer> NPC_MENU_ACTIONS = new HashSet<Integer>(Arrays.asList(MenuAction.NPC_FIRST_OPTION.getId(), MenuAction.NPC_SECOND_OPTION.getId(), MenuAction.NPC_THIRD_OPTION.getId(), MenuAction.NPC_FOURTH_OPTION.getId(), MenuAction.NPC_FIFTH_OPTION.getId(), MenuAction.EXAMINE_NPC.getId()));
    public int hoverNpcIndex = -1;
    @Inject
    private NpcIdConfig config;
    @Inject
    private NpcIdOverlay npcOverlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    NpcIdConfig providesConfig(ConfigManager configManager) {
        return (NpcIdConfig)configManager.getConfig(NpcIdConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.npcOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.npcOverlay);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        this.hoverNpcIndex = NPC_MENU_ACTIONS.contains(event.getType()) ? event.getIdentifier() : -1;
    }
}

