/*
 * Decompiled with CFR 0.152.
 */
package xrio.npcid;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import xrio.npcid.NpcIdConfig;
import xrio.npcid.NpcIdPlugin;

public class NpcIdOverlay
extends Overlay {
    private final Client client;
    private final NpcIdConfig config;
    private final NpcIdPlugin plugin;

    @Inject
    NpcIdOverlay(Client client, NpcIdConfig config, NpcIdPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!(this.config.showId() || this.config.showIndex() || this.config.showName())) {
            return null;
        }
        for (NPC npc : this.client.getCachedNPCs()) {
            if (npc == null || npc.getId() < 0 || npc.getName() == null || npc.getName().isEmpty() || "null".equals(npc.getName())) continue;
            this.renderNpcOverlay(graphics, npc, this.config.textColour());
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC npc, Color colour) {
        Point textLocation;
        if (this.config.hoverOnly() && this.plugin.hoverNpcIndex != npc.getIndex()) {
            return;
        }
        Object text = "";
        if (this.config.showName()) {
            text = (String)text + npc.getName();
        }
        if (this.config.showId()) {
            text = (String)text + (this.config.showName() ? " " : "") + npc.getId();
        }
        if (this.config.showIndex()) {
            text = (String)text + (this.config.showName() ? " " : "") + "#" + npc.getIndex();
        }
        if ((textLocation = npc.getCanvasTextLocation(graphics, (String)text, npc.getLogicalHeight() + 40)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)colour);
        }
    }
}

